/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.street.search.state;

import java.time.Instant;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Set;
import javax.annotation.Nonnull;
import org.opentripplanner.astar.spi.AStarState;
import org.opentripplanner.ext.dataoverlay.routing.DataOverlayContext;
import org.opentripplanner.framework.lang.ObjectUtils;
import org.opentripplanner.framework.tostring.ToStringBuilder;
import org.opentripplanner.routing.api.request.preference.RoutingPreferences;
import org.opentripplanner.service.vehiclerental.street.VehicleRentalEdge;
import org.opentripplanner.service.vehiclerental.street.VehicleRentalPlaceVertex;
import org.opentripplanner.street.model.RentalFormFactor;
import org.opentripplanner.street.model.edge.Edge;
import org.opentripplanner.street.model.vertex.Vertex;
import org.opentripplanner.street.search.TraverseMode;
import org.opentripplanner.street.search.intersection_model.IntersectionTraversalCalculator;
import org.opentripplanner.street.search.request.StreetSearchRequest;
import org.opentripplanner.street.search.state.CarPickupState;
import org.opentripplanner.street.search.state.StateData;
import org.opentripplanner.street.search.state.StateEditor;
import org.opentripplanner.street.search.state.VehicleRentalState;

public class State
implements AStarState<State, Edge, Vertex>,
Cloneable {
    private final StreetSearchRequest request;
    protected long time;
    public double weight;
    protected Vertex vertex;
    protected State backState;
    public Edge backEdge;
    protected State next;
    public StateData stateData;
    public double walkDistance;

    public State(@Nonnull Vertex vertex, @Nonnull StreetSearchRequest streetSearchRequest) {
        this(vertex, streetSearchRequest.startTime(), StateData.getInitialStateData(streetSearchRequest), streetSearchRequest);
    }

    public State(@Nonnull Vertex vertex, @Nonnull Instant startTime, @Nonnull StateData stateData, @Nonnull StreetSearchRequest request) {
        this.request = request;
        this.weight = 0.0;
        this.vertex = vertex;
        this.backState = null;
        this.stateData = stateData;
        if (!vertex.rentalRestrictions().noDropOffNetworks().isEmpty()) {
            this.stateData.noRentalDropOffZonesAtStartOfReverseSearch = vertex.rentalRestrictions().noDropOffNetworks();
        }
        this.walkDistance = 0.0;
        this.time = startTime.getEpochSecond();
    }

    public static Collection<State> getInitialStates(Set<Vertex> vertices, StreetSearchRequest streetSearchRequest) {
        ArrayList<State> states = new ArrayList<State>();
        for (Vertex vertex : vertices) {
            for (StateData stateData : StateData.getInitialStateDatas(streetSearchRequest)) {
                states.add(new State(vertex, streetSearchRequest.startTime(), stateData, streetSearchRequest));
            }
        }
        return states;
    }

    public StateEditor edit(Edge e) {
        return new StateEditor(this, e);
    }

    public CarPickupState getCarPickupState() {
        return this.stateData.carPickupState;
    }

    @Override
    public long getTimeSeconds() {
        return this.time;
    }

    @Override
    public long getElapsedTimeSeconds() {
        return Math.abs(this.getTimeSeconds() - this.request.startTime().getEpochSecond());
    }

    public boolean isCompatibleVehicleRentalState(State state) {
        return this.stateData.vehicleRentalState == state.stateData.vehicleRentalState && this.stateData.mayKeepRentedVehicleAtDestination == state.stateData.mayKeepRentedVehicleAtDestination;
    }

    public boolean isRentingVehicleFromStation() {
        return this.stateData.vehicleRentalState == VehicleRentalState.RENTING_FROM_STATION;
    }

    public boolean isRentingFloatingVehicle() {
        return this.stateData.vehicleRentalState == VehicleRentalState.RENTING_FLOATING;
    }

    public boolean isRentingVehicle() {
        return this.stateData.vehicleRentalState == VehicleRentalState.RENTING_FROM_STATION || this.stateData.vehicleRentalState == VehicleRentalState.RENTING_FLOATING;
    }

    public boolean vehicleRentalIsFinished() {
        return this.stateData.vehicleRentalState == VehicleRentalState.HAVE_RENTED || this.stateData.vehicleRentalState == VehicleRentalState.RENTING_FLOATING && !this.stateData.insideNoRentalDropOffArea || this.getRequest().rental().allowArrivingInRentedVehicleAtDestination() && this.stateData.mayKeepRentedVehicleAtDestination && this.stateData.vehicleRentalState == VehicleRentalState.RENTING_FROM_STATION;
    }

    public boolean vehicleRentalNotStarted() {
        return this.stateData.vehicleRentalState == VehicleRentalState.BEFORE_RENTING;
    }

    public VehicleRentalState getVehicleRentalState() {
        return this.stateData.vehicleRentalState;
    }

    public boolean isVehicleParked() {
        return this.stateData.vehicleParked;
    }

    @Override
    public boolean isFinal() {
        boolean vehicleParkAndRideOk;
        boolean vehicleRentingOk;
        boolean parkAndRide = this.request.mode().includesParking();
        if (this.request.arriveBy()) {
            vehicleRentingOk = !this.request.mode().includesRenting() || !this.isRentingVehicle();
            vehicleParkAndRideOk = !parkAndRide || !this.isVehicleParked();
        } else {
            vehicleRentingOk = !this.request.mode().includesRenting() || this.vehicleRentalNotStarted() || this.vehicleRentalIsFinished();
            vehicleParkAndRideOk = !parkAndRide || this.isVehicleParked();
        }
        return vehicleRentingOk && vehicleParkAndRideOk;
    }

    public RentalFormFactor vehicleRentalFormFactor() {
        return this.stateData.rentalVehicleFormFactor;
    }

    public double getWalkDistance() {
        return this.walkDistance;
    }

    @Override
    public Vertex getVertex() {
        return this.vertex;
    }

    @Override
    public double getWeight() {
        return this.weight;
    }

    public int getTimeDeltaSeconds() {
        return this.backState != null ? (int)(this.getTimeSeconds() - this.backState.getTimeSeconds()) : 0;
    }

    public double getWeightDelta() {
        return this.weight - this.backState.weight;
    }

    @Override
    public State getBackState() {
        return this.backState;
    }

    public TraverseMode getBackMode() {
        return this.stateData.backMode;
    }

    public boolean isBackWalkingBike() {
        return this.stateData.backWalkingBike;
    }

    @Override
    public Edge getBackEdge() {
        return this.backEdge;
    }

    @Override
    public void initBackEdge(Edge initialBackEdge) {
        this.backEdge = ObjectUtils.requireNotInitialized(this.backEdge, initialBackEdge);
    }

    @Override
    public State getNextResult() {
        return this.next;
    }

    public State addToExistingResultChain(State existingResultChain) {
        if (this.getNextResult() != null) {
            throw new IllegalStateException("this result already has a next result set");
        }
        this.next = existingResultChain;
        return this;
    }

    @Override
    public StreetSearchRequest getRequest() {
        return this.request;
    }

    public RoutingPreferences getPreferences() {
        return this.request.preferences();
    }

    public TraverseMode getNonTransitMode() {
        return this.stateData.currentMode;
    }

    @Override
    public Instant getTime() {
        return Instant.ofEpochSecond(this.time);
    }

    public String getVehicleRentalNetwork() {
        return this.stateData.vehicleRentalNetwork;
    }

    public boolean unknownRentalNetwork() {
        return this.stateData.vehicleRentalNetwork == null;
    }

    @Override
    public State reverse() {
        State orig = this;
        State ret = orig.reversedClone();
        while (orig.getBackState() != null) {
            Edge edge = orig.getBackEdge();
            StateEditor editor = ret.edit(edge);
            editor.setFromState(orig);
            editor.incrementTimeInSeconds(orig.getAbsTimeDeltaSeconds());
            editor.incrementWeight(orig.getWeightDelta());
            editor.incrementWalkDistance(orig.getWalkDistanceDelta());
            editor.setBackMode(orig.getBackMode());
            if (orig.isRentingVehicle() && !orig.getBackState().isRentingVehicle()) {
                Vertex vertex = orig.vertex;
                if (vertex instanceof VehicleRentalPlaceVertex) {
                    stationVertex = (VehicleRentalPlaceVertex)vertex;
                    editor.dropOffRentedVehicleAtStation(((VehicleRentalEdge)edge).formFactor, stationVertex.getStation().getNetwork(), false);
                } else {
                    editor.dropFloatingVehicle(orig.stateData.rentalVehicleFormFactor, orig.getVehicleRentalNetwork(), false);
                }
            } else if (!orig.isRentingVehicle() && orig.getBackState().isRentingVehicle()) {
                stationVertex = (VehicleRentalPlaceVertex)orig.vertex;
                if (orig.getBackState().isRentingVehicleFromStation()) {
                    editor.beginVehicleRentingAtStation(((VehicleRentalEdge)edge).formFactor, stationVertex.getStation().getNetwork(), orig.backState.mayKeepRentedVehicleAtDestination(), false);
                } else if (orig.getBackState().isRentingFloatingVehicle()) {
                    editor.beginFloatingVehicleRenting(((VehicleRentalEdge)edge).formFactor, stationVertex.getStation().getNetwork(), false);
                }
            }
            if (orig.isVehicleParked() != orig.getBackState().isVehicleParked()) {
                editor.setVehicleParked(true, orig.getBackState().getNonTransitMode());
            }
            ret = editor.makeState();
            orig = orig.getBackState();
        }
        return ret;
    }

    public boolean hasEnteredNoThruTrafficArea() {
        return this.stateData.enteredNoThroughTrafficArea;
    }

    public boolean mayKeepRentedVehicleAtDestination() {
        return this.stateData.mayKeepRentedVehicleAtDestination;
    }

    public IntersectionTraversalCalculator intersectionTraversalCalculator() {
        return this.request.intersectionTraversalCalculator();
    }

    public DataOverlayContext dataOverlayContext() {
        return this.request.dataOverlayContext();
    }

    public boolean isInsideNoRentalDropOffArea() {
        return this.stateData.insideNoRentalDropOffArea;
    }

    protected State clone() {
        State ret;
        try {
            ret = (State)super.clone();
        }
        catch (CloneNotSupportedException e1) {
            throw new IllegalStateException("This is not happening");
        }
        return ret;
    }

    public String toString() {
        return ToStringBuilder.of(State.class).addDateTime("time", this.getTime()).addNum("weight", this.weight).addObj("vertex", this.vertex).addBoolIfTrue("VEHICLE_RENT", this.isRentingVehicle()).addBoolIfTrue("VEHICLE_PARKED", this.isVehicleParked()).toString();
    }

    void checkNegativeWeight() {
        double dw = this.weight - this.backState.weight;
        if (dw < 0.0) {
            throw new NegativeWeightException(dw + " on edge " + this.backEdge);
        }
    }

    private int getAbsTimeDeltaSeconds() {
        return Math.abs(this.getTimeDeltaSeconds());
    }

    private double getWalkDistanceDelta() {
        if (this.backState != null) {
            return Math.abs(this.walkDistance - this.backState.walkDistance);
        }
        return 0.0;
    }

    private State reversedClone() {
        StreetSearchRequest reversedRequest = this.request.copyOfReversed(this.getTime()).withPreferences(p -> p.withRental(r -> r.withUseAvailabilityInformation(false))).build();
        StateData newStateData = this.stateData.clone();
        newStateData.backMode = null;
        return new State(this.vertex, this.getTime(), newStateData, reversedRequest);
    }

    private static class NegativeWeightException
    extends RuntimeException {
        public NegativeWeightException(String message) {
            super(message);
        }
    }
}

