/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.street.search.request;

import java.time.Instant;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.Envelope;
import org.opentripplanner.astar.spi.AStarRequest;
import org.opentripplanner.ext.dataoverlay.routing.DataOverlayContext;
import org.opentripplanner.framework.geometry.SphericalDistanceLibrary;
import org.opentripplanner.model.GenericLocation;
import org.opentripplanner.routing.api.request.StreetMode;
import org.opentripplanner.routing.api.request.preference.RoutingPreferences;
import org.opentripplanner.routing.api.request.request.VehicleParkingRequest;
import org.opentripplanner.routing.api.request.request.VehicleRentalRequest;
import org.opentripplanner.street.model.vertex.Vertex;
import org.opentripplanner.street.search.intersection_model.IntersectionTraversalCalculator;
import org.opentripplanner.street.search.request.StreetSearchRequestBuilder;

public class StreetSearchRequest
implements AStarRequest {
    private static final StreetSearchRequest DEFAULT = new StreetSearchRequest();
    private static final int MAX_CLOSENESS_METERS = 500;
    private final Instant startTime;
    private final RoutingPreferences preferences;
    private final StreetMode mode;
    private final boolean arriveBy;
    private final boolean wheelchair;
    private final VehicleParkingRequest parking;
    private final VehicleRentalRequest rental;
    private final GenericLocation from;
    private final Envelope fromEnvelope;
    private final GenericLocation to;
    private final Envelope toEnvelope;
    private IntersectionTraversalCalculator intersectionTraversalCalculator = IntersectionTraversalCalculator.DEFAULT;
    private DataOverlayContext dataOverlayContext;

    private StreetSearchRequest() {
        this.startTime = Instant.now();
        this.preferences = new RoutingPreferences();
        this.mode = StreetMode.WALK;
        this.arriveBy = false;
        this.wheelchair = false;
        this.parking = new VehicleParkingRequest();
        this.rental = new VehicleRentalRequest();
        this.from = null;
        this.fromEnvelope = null;
        this.to = null;
        this.toEnvelope = null;
    }

    StreetSearchRequest(StreetSearchRequestBuilder builder) {
        this.startTime = builder.startTime;
        this.preferences = builder.preferences;
        this.mode = builder.mode;
        this.arriveBy = builder.arriveBy;
        this.wheelchair = builder.wheelchair;
        this.parking = builder.parking;
        this.rental = builder.rental;
        this.from = builder.from;
        this.fromEnvelope = StreetSearchRequest.createEnvelope(this.from);
        this.to = builder.to;
        this.toEnvelope = StreetSearchRequest.createEnvelope(this.to);
    }

    @Nonnull
    public static StreetSearchRequestBuilder of() {
        return new StreetSearchRequestBuilder(DEFAULT).withStartTime(Instant.now());
    }

    @Nonnull
    public static StreetSearchRequestBuilder copyOf(StreetSearchRequest original) {
        return new StreetSearchRequestBuilder(original);
    }

    public Instant startTime() {
        return this.startTime;
    }

    public RoutingPreferences preferences() {
        return this.preferences;
    }

    public StreetMode mode() {
        return this.mode;
    }

    @Override
    public boolean arriveBy() {
        return this.arriveBy;
    }

    public boolean wheelchair() {
        return this.wheelchair;
    }

    public VehicleParkingRequest parking() {
        return this.parking;
    }

    public VehicleRentalRequest rental() {
        return this.rental;
    }

    public GenericLocation from() {
        return this.from;
    }

    public GenericLocation to() {
        return this.to;
    }

    public IntersectionTraversalCalculator intersectionTraversalCalculator() {
        return this.intersectionTraversalCalculator;
    }

    public DataOverlayContext dataOverlayContext() {
        return this.dataOverlayContext;
    }

    public StreetSearchRequestBuilder copyOfReversed(Instant time) {
        return StreetSearchRequest.copyOf(this).withStartTime(time).withArriveBy(!this.arriveBy);
    }

    public void setIntersectionTraversalCalculator(IntersectionTraversalCalculator intersectionTraversalCalculator) {
        this.intersectionTraversalCalculator = intersectionTraversalCalculator;
    }

    public void setDataOverlayContext(DataOverlayContext dataOverlayContext) {
        this.dataOverlayContext = dataOverlayContext;
    }

    public boolean isCloseToStartOrEnd(Vertex vertex) {
        return this.fromEnvelope != null && this.fromEnvelope.intersects(vertex.getCoordinate()) || this.toEnvelope != null && this.toEnvelope.intersects(vertex.getCoordinate());
    }

    @Nullable
    private static Envelope createEnvelope(GenericLocation location) {
        if (location == null) {
            return null;
        }
        Coordinate coordinate = location.getCoordinate();
        if (coordinate == null) {
            return null;
        }
        double lat = SphericalDistanceLibrary.metersToDegrees(500.0);
        double lon = SphericalDistanceLibrary.metersToLonDegrees(500.0, coordinate.y);
        Envelope env = new Envelope(coordinate);
        env.expandBy(lon, lat);
        return env;
    }
}

