/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.street.model.vertex;

import org.opentripplanner.framework.i18n.I18NString;
import org.opentripplanner.framework.i18n.NonLocalizedString;
import org.opentripplanner.framework.lang.BitSetUtils;
import org.opentripplanner.routing.graph.Graph;
import org.opentripplanner.street.model.vertex.StreetVertex;

public class IntersectionVertex
extends StreetVertex {
    private static final int HIGHWAY_TRAFFIC_LIGHT_INDEX = 0;
    private static final int CROSSING_TRAFFIC_LIGHT_INDEX = 1;
    private final short flags;

    public IntersectionVertex(Graph g, String label, double x, double y, String name) {
        this(g, label, x, y, new NonLocalizedString(name), false, false);
    }

    public IntersectionVertex(Graph g, String label, double x, double y, I18NString name, boolean hasHighwayTrafficLight, boolean hasCrossingTrafficLight) {
        super(g, label, x, y, name);
        this.flags = IntersectionVertex.initFlags(hasHighwayTrafficLight, hasCrossingTrafficLight);
    }

    public IntersectionVertex(Graph g, String label, double x, double y) {
        this(g, label, x, y, new NonLocalizedString(label), false, false);
    }

    public IntersectionVertex(Graph g, String label, double x, double y, boolean hasHighwayTrafficLight, boolean hasCrossingTrafficLight) {
        this(g, label, x, y, new NonLocalizedString(label), hasHighwayTrafficLight, hasCrossingTrafficLight);
    }

    public boolean hasCyclingTrafficLight() {
        return !this.hasNoTrafficLight();
    }

    public boolean hasWalkingTrafficLight() {
        return BitSetUtils.get(this.flags, 1);
    }

    public boolean hasDrivingTrafficLight() {
        return BitSetUtils.get(this.flags, 0);
    }

    public boolean inferredFreeFlowing() {
        return this.getDegreeIn() == 1 && this.getDegreeOut() == 1 && this.hasNoTrafficLight();
    }

    private boolean hasNoTrafficLight() {
        return this.flags == 0;
    }

    private static short initFlags(boolean highwayTrafficLight, boolean crossingTrafficLight) {
        short flags = 0;
        flags = BitSetUtils.set(flags, 0, highwayTrafficLight);
        flags = BitSetUtils.set(flags, 1, crossingTrafficLight);
        return flags;
    }
}

