/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.street.model.elevation;

import org.geotools.geometry.DirectPosition3D;
import org.geotools.referencing.operation.DefaultMathTransformFactory;
import org.geotools.referencing.operation.transform.EarthGravitationalModel;
import org.opengis.geometry.DirectPosition;
import org.opengis.referencing.FactoryException;
import org.opengis.referencing.operation.MathTransform;
import org.opengis.referencing.operation.TransformException;

public class ElevationUtils {
    private static MathTransform mt;

    public static synchronized double computeEllipsoidToGeoidDifference(double lat, double lon) throws TransformException {
        DirectPosition3D dest = new DirectPosition3D();
        mt.transform((DirectPosition)new DirectPosition3D(lon, lat, 0.0), (DirectPosition)dest);
        return dest.z;
    }

    static {
        try {
            mt = new DefaultMathTransformFactory().createParameterizedTransform(new EarthGravitationalModel.Provider().getParameters().createValue());
        }
        catch (FactoryException e) {
            e.printStackTrace();
        }
    }
}

