/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.street.model.edge;

import org.locationtech.jts.geom.LineString;
import org.opentripplanner.framework.i18n.I18NString;
import org.opentripplanner.routing.api.request.StreetMode;
import org.opentripplanner.routing.api.request.preference.BikePreferences;
import org.opentripplanner.routing.api.request.preference.CarPreferences;
import org.opentripplanner.routing.api.request.preference.RoutingPreferences;
import org.opentripplanner.routing.api.request.request.VehicleParkingRequest;
import org.opentripplanner.routing.vehicle_parking.VehicleParking;
import org.opentripplanner.street.model.edge.Edge;
import org.opentripplanner.street.model.vertex.VehicleParkingEntranceVertex;
import org.opentripplanner.street.search.TraverseMode;
import org.opentripplanner.street.search.request.StreetSearchRequest;
import org.opentripplanner.street.search.state.State;
import org.opentripplanner.street.search.state.StateEditor;

public class VehicleParkingEdge
extends Edge {
    private final VehicleParking vehicleParking;

    public VehicleParkingEdge(VehicleParkingEntranceVertex vehicleParkingEntranceVertex) {
        this(vehicleParkingEntranceVertex, vehicleParkingEntranceVertex);
    }

    public VehicleParkingEdge(VehicleParkingEntranceVertex fromVehicleParkingEntranceVertex, VehicleParkingEntranceVertex toVehicleParkingEntranceVertex) {
        super(fromVehicleParkingEntranceVertex, toVehicleParkingEntranceVertex);
        this.vehicleParking = fromVehicleParkingEntranceVertex.getVehicleParking();
    }

    public VehicleParking getVehicleParking() {
        return this.vehicleParking;
    }

    public boolean equals(Object o) {
        if (o instanceof VehicleParkingEdge) {
            VehicleParkingEdge other = (VehicleParkingEdge)o;
            return other.getFromVertex().equals(this.fromv) && other.getToVertex().equals(this.tov);
        }
        return false;
    }

    @Override
    public String toString() {
        return "VehicleParkingEdge(" + this.fromv + " -> " + this.tov + ")";
    }

    @Override
    public State traverse(State s0) {
        if (!s0.getRequest().mode().includesParking()) {
            return null;
        }
        if (s0.getRequest().arriveBy()) {
            return this.traverseUnPark(s0);
        }
        return this.traversePark(s0);
    }

    @Override
    public I18NString getName() {
        return this.getToVertex().getName();
    }

    @Override
    public boolean hasBogusName() {
        return false;
    }

    @Override
    public LineString getGeometry() {
        return null;
    }

    @Override
    public double getDistanceMeters() {
        return 0.0;
    }

    protected State traverseUnPark(State s0) {
        if (s0.getNonTransitMode() != TraverseMode.WALK || !s0.isVehicleParked()) {
            return null;
        }
        StreetMode streetMode = s0.getRequest().mode();
        if (streetMode.includesBiking()) {
            BikePreferences bike = s0.getPreferences().bike();
            return this.traverseUnPark(s0, bike.parkCost(), bike.parkTime(), TraverseMode.BICYCLE);
        }
        if (streetMode.includesDriving()) {
            CarPreferences car = s0.getPreferences().car();
            return this.traverseUnPark(s0, car.parkCost(), car.parkTime(), TraverseMode.CAR);
        }
        return null;
    }

    private State traverseUnPark(State s0, int parkingCost, int parkingTime, TraverseMode mode) {
        StreetSearchRequest request = s0.getRequest();
        if (!this.vehicleParking.hasSpacesAvailable(mode, request.wheelchair(), request.parking().useAvailabilityInformation())) {
            return null;
        }
        StateEditor s0e = s0.edit(this);
        s0e.incrementWeight(parkingCost);
        s0e.incrementTimeInSeconds(parkingTime);
        s0e.setVehicleParked(false, mode);
        this.addUnpreferredTagCost(request.parking(), s0e);
        return s0e.makeState();
    }

    private State traversePark(State s0) {
        StreetMode streetMode = s0.getRequest().mode();
        RoutingPreferences preferences = s0.getPreferences();
        if (!streetMode.includesWalking() || s0.isVehicleParked()) {
            return null;
        }
        if (streetMode.includesBiking()) {
            if (s0.isRentingVehicle()) {
                return null;
            }
            return this.traversePark(s0, preferences.bike().parkCost(), preferences.bike().parkTime());
        }
        if (streetMode.includesDriving()) {
            return this.traversePark(s0, preferences.car().parkCost(), preferences.car().parkTime());
        }
        return null;
    }

    private State traversePark(State s0, int parkingCost, int parkingTime) {
        if (!this.vehicleParking.hasSpacesAvailable(s0.getNonTransitMode(), s0.getRequest().wheelchair(), s0.getRequest().parking().useAvailabilityInformation())) {
            return null;
        }
        StateEditor s0e = s0.edit(this);
        s0e.incrementWeight(parkingCost);
        s0e.incrementTimeInSeconds(parkingTime);
        s0e.setVehicleParked(true, TraverseMode.WALK);
        this.addUnpreferredTagCost(s0.getRequest().parking(), s0e);
        return s0e.makeState();
    }

    private void addUnpreferredTagCost(VehicleParkingRequest req, StateEditor s0e) {
        if (!req.preferred().matches(this.vehicleParking)) {
            s0e.incrementWeight(req.unpreferredCost());
        }
    }
}

