/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.street.model;

import org.opentripplanner.street.search.TraverseMode;
import org.opentripplanner.street.search.TraverseModeSet;

public enum StreetTraversalPermission {
    NONE(0),
    PEDESTRIAN(1),
    BICYCLE(2),
    PEDESTRIAN_AND_BICYCLE(3),
    CAR(4),
    PEDESTRIAN_AND_CAR(5),
    BICYCLE_AND_CAR(6),
    ALL(7);

    private static final StreetTraversalPermission[] lookup;
    public final int code;

    private StreetTraversalPermission(int code) {
        this.code = code;
    }

    public static StreetTraversalPermission get(int code) {
        return lookup[code];
    }

    public StreetTraversalPermission add(StreetTraversalPermission perm) {
        return StreetTraversalPermission.get(this.code | perm.code);
    }

    public StreetTraversalPermission intersection(StreetTraversalPermission perm) {
        return StreetTraversalPermission.get(this.code & perm.code);
    }

    public StreetTraversalPermission remove(StreetTraversalPermission perm) {
        return StreetTraversalPermission.get(this.code & ~perm.code);
    }

    public StreetTraversalPermission modify(boolean permissive, StreetTraversalPermission perm) {
        return permissive ? this.add(perm) : this.remove(perm);
    }

    public boolean allows(StreetTraversalPermission perm) {
        return (this.code & perm.code) != 0;
    }

    public boolean allows(TraverseModeSet modes) {
        if (modes.getWalk() && this.allows(PEDESTRIAN)) {
            return true;
        }
        if (modes.getBicycle() && this.allows(BICYCLE)) {
            return true;
        }
        return modes.getCar() && this.allows(CAR);
    }

    public boolean allows(TraverseMode mode) {
        if (mode == TraverseMode.WALK && this.allows(PEDESTRIAN)) {
            return true;
        }
        if (mode.isCyclingIsh() && this.allows(BICYCLE)) {
            return true;
        }
        return mode == TraverseMode.CAR && this.allows(CAR);
    }

    public boolean allowsAnything() {
        return !this.allowsNothing();
    }

    public boolean allowsNothing() {
        return this == NONE;
    }

    static {
        lookup = new StreetTraversalPermission[StreetTraversalPermission.values().length];
        StreetTraversalPermission[] streetTraversalPermissionArray = StreetTraversalPermission.values();
        int n = streetTraversalPermissionArray.length;
        for (int i = 0; i < n; ++i) {
            StreetTraversalPermission s;
            StreetTraversalPermission.lookup[s.code] = s = streetTraversalPermissionArray[i];
        }
    }
}

