/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.standalone.server;

import jakarta.ws.rs.core.Application;
import java.io.File;
import java.io.IOException;
import java.net.BindException;
import org.glassfish.grizzly.http.CompressionConfig;
import org.glassfish.grizzly.http.server.CLStaticHttpHandler;
import org.glassfish.grizzly.http.server.HttpHandler;
import org.glassfish.grizzly.http.server.HttpServer;
import org.glassfish.grizzly.http.server.NetworkListener;
import org.glassfish.grizzly.http.server.StaticHttpHandler;
import org.glassfish.grizzly.ssl.SSLContextConfigurator;
import org.glassfish.grizzly.ssl.SSLEngineConfigurator;
import org.glassfish.grizzly.threadpool.ThreadPoolConfig;
import org.glassfish.jersey.server.ContainerFactory;
import org.opentripplanner.framework.application.OTPFeature;
import org.opentripplanner.standalone.config.CommandLineParameters;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.bridge.SLF4JBridgeHandler;

public class GrizzlyServer {
    private static final Logger LOG = LoggerFactory.getLogger(GrizzlyServer.class);
    private static final int MIN_THREADS = 4;
    private final CommandLineParameters params;
    private final Application app;

    public GrizzlyServer(CommandLineParameters params, Application app) {
        this.params = params;
        this.app = app;
    }

    public void run() {
        LOG.info("Starting OTP Grizzly server on ports {} (HTTP) and {} (HTTPS) of interface {}", new Object[]{this.params.port, this.params.securePort, this.params.bindAddress});
        LOG.info("OTP server base directory is: {}", this.params.baseDirectory);
        HttpServer httpServer = new HttpServer();
        SSLContextConfigurator sslConfig = new SSLContextConfigurator();
        sslConfig.setKeyStoreFile(new File(this.params.getBaseDirectory(), "keystore").getAbsolutePath());
        sslConfig.setKeyStorePass("opentrip");
        int nHandlerThreads = this.getMaxThreads();
        ThreadPoolConfig threadPoolConfig = ThreadPoolConfig.defaultConfig().setCorePoolSize(nHandlerThreads).setMaxPoolSize(nHandlerThreads).setQueueLimit(-1);
        NetworkListener httpListener = new NetworkListener("otp_insecure", this.params.bindAddress, this.params.port.intValue());
        httpListener.setSecure(false);
        NetworkListener httpsListener = new NetworkListener("otp_secure", this.params.bindAddress, this.params.securePort.intValue());
        httpsListener.setSecure(true);
        httpsListener.setSSLEngineConfig(new SSLEngineConfigurator(sslConfig).setClientMode(false).setNeedClientAuth(false));
        for (NetworkListener listener : new NetworkListener[]{httpListener, httpsListener}) {
            CompressionConfig cc = listener.getCompressionConfig();
            cc.setCompressionMode(CompressionConfig.CompressionMode.ON);
            cc.setCompressionMinSize(50000);
            cc.setCompressableMimeTypes(new String[]{"application/json", "text/json"});
            listener.getTransport().setWorkerThreadPoolConfig(threadPoolConfig);
            httpServer.addListener(listener);
        }
        HttpHandler dynamicHandler = (HttpHandler)ContainerFactory.createContainer(HttpHandler.class, (Application)this.app);
        httpServer.getServerConfiguration().addHttpHandler(dynamicHandler, new String[]{"/otp/"});
        if (OTPFeature.DebugClient.isOn()) {
            CLStaticHttpHandler staticHandler = new CLStaticHttpHandler(GrizzlyServer.class.getClassLoader(), new String[]{"/client/"});
            if (this.params.disableFileCache) {
                LOG.info("Disabling HTTP server static file cache.");
                staticHandler.setFileCacheEnabled(false);
            }
            httpServer.getServerConfiguration().addHttpHandler((HttpHandler)staticHandler, new String[]{"/"});
        }
        if (this.params.clientDirectory != null) {
            StaticHttpHandler localHandler = new StaticHttpHandler(new String[]{this.params.clientDirectory.getAbsolutePath()});
            localHandler.setFileCacheEnabled(false);
            httpServer.getServerConfiguration().addHttpHandler((HttpHandler)localHandler, new String[]{"/local"});
        }
        Thread shutdownThread = new Thread(() -> ((HttpServer)httpServer).shutdown());
        Runtime.getRuntime().addShutdownHook(shutdownThread);
        try {
            httpServer.start();
            LOG.info("Grizzly server running.");
            Thread.currentThread().join();
        }
        catch (BindException be) {
            LOG.error("Cannot bind to port {}. Is it already in use?", (Object)this.params.port);
        }
        catch (IOException ioe) {
            LOG.error("IO exception while starting server.");
        }
        catch (InterruptedException ie) {
            LOG.info("Interrupted, shutting down.");
        }
        Runtime.getRuntime().removeShutdownHook(shutdownThread);
        httpServer.shutdown();
    }

    private int getMaxThreads() {
        int maxThreads = Runtime.getRuntime().availableProcessors();
        LOG.info("Java reports that this machine has {} available processors.", (Object)maxThreads);
        maxThreads = (int)((double)maxThreads * 1.25);
        if (this.params.maxThreads != null) {
            maxThreads = this.params.maxThreads;
            LOG.info("Based on configuration, forced max thread pool size to {} threads.", (Object)maxThreads);
        }
        if (maxThreads < 4) {
            maxThreads = 4;
        }
        LOG.info("Maximum HTTP handler thread pool size will be {} threads.", (Object)maxThreads);
        return maxThreads;
    }

    static {
        SLF4JBridgeHandler.removeHandlersForRootLogger();
        SLF4JBridgeHandler.install();
    }
}

