/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.standalone.server;

import io.micrometer.core.instrument.MeterRegistry;
import java.util.List;
import java.util.Locale;
import javax.annotation.Nullable;
import org.opentripplanner.astar.spi.TraverseVisitor;
import org.opentripplanner.ext.ridehailing.RideHailingService;
import org.opentripplanner.ext.vectortiles.VectorTilesResource;
import org.opentripplanner.inspector.raster.TileRendererManager;
import org.opentripplanner.raptor.api.request.RaptorTuningParameters;
import org.opentripplanner.raptor.configure.RaptorConfig;
import org.opentripplanner.routing.algorithm.raptoradapter.transit.TransitTuningParameters;
import org.opentripplanner.routing.algorithm.raptoradapter.transit.TripSchedule;
import org.opentripplanner.routing.api.RoutingService;
import org.opentripplanner.routing.api.request.RouteRequest;
import org.opentripplanner.routing.graph.Graph;
import org.opentripplanner.routing.service.DefaultRoutingService;
import org.opentripplanner.service.vehiclepositions.VehiclePositionService;
import org.opentripplanner.service.vehiclerental.VehicleRentalService;
import org.opentripplanner.service.worldenvelope.WorldEnvelopeService;
import org.opentripplanner.standalone.api.OtpServerRequestContext;
import org.opentripplanner.standalone.config.routerconfig.TransitRoutingConfig;
import org.opentripplanner.standalone.config.sandbox.FlexConfig;
import org.opentripplanner.standalone.configure.RequestLoggerFactory;
import org.opentripplanner.transit.service.TransitService;
import org.slf4j.Logger;

public class DefaultServerRequestContext
implements OtpServerRequestContext {
    private final List<RideHailingService> rideHailingServices;
    private RouteRequest routeRequest = null;
    private final Graph graph;
    private final TransitService transitService;
    private final TransitRoutingConfig transitRoutingConfig;
    private final RouteRequest routeRequestDefaults;
    private final MeterRegistry meterRegistry;
    private final RaptorConfig<TripSchedule> raptorConfig;
    private final Logger requestLogger;
    private final TileRendererManager tileRendererManager;
    private final VectorTilesResource.LayersParameters<VectorTilesResource.LayerType> vectorTileLayers;
    private final FlexConfig flexConfig;
    private final TraverseVisitor traverseVisitor;
    private final WorldEnvelopeService worldEnvelopeService;
    private final VehiclePositionService vehiclePositionService;
    private final VehicleRentalService vehicleRentalService;

    private DefaultServerRequestContext(Graph graph, TransitService transitService, TransitRoutingConfig transitRoutingConfig, RouteRequest routeRequestDefaults, MeterRegistry meterRegistry, RaptorConfig<TripSchedule> raptorConfig, Logger requestLogger, TileRendererManager tileRendererManager, VectorTilesResource.LayersParameters<VectorTilesResource.LayerType> vectorTileLayers, WorldEnvelopeService worldEnvelopeService, VehiclePositionService vehiclePositionService, VehicleRentalService vehicleRentalService, List<RideHailingService> rideHailingServices, TraverseVisitor traverseVisitor, FlexConfig flexConfig) {
        this.graph = graph;
        this.transitService = transitService;
        this.transitRoutingConfig = transitRoutingConfig;
        this.meterRegistry = meterRegistry;
        this.raptorConfig = raptorConfig;
        this.requestLogger = requestLogger;
        this.tileRendererManager = tileRendererManager;
        this.vectorTileLayers = vectorTileLayers;
        this.vehicleRentalService = vehicleRentalService;
        this.flexConfig = flexConfig;
        this.traverseVisitor = traverseVisitor;
        this.routeRequestDefaults = routeRequestDefaults;
        this.worldEnvelopeService = worldEnvelopeService;
        this.vehiclePositionService = vehiclePositionService;
        this.rideHailingServices = rideHailingServices;
    }

    public static DefaultServerRequestContext create(TransitRoutingConfig transitRoutingConfig, RouteRequest routeRequestDefaults, RaptorConfig<TripSchedule> raptorConfig, Graph graph, TransitService transitService, MeterRegistry meterRegistry, VectorTilesResource.LayersParameters<VectorTilesResource.LayerType> vectorTileLayers, WorldEnvelopeService worldEnvelopeService, VehiclePositionService vehiclePositionService, VehicleRentalService vehicleRentalService, FlexConfig flexConfig, List<RideHailingService> rideHailingServices, @Nullable TraverseVisitor traverseVisitor, @Nullable String requestLogFile) {
        return new DefaultServerRequestContext(graph, transitService, transitRoutingConfig, routeRequestDefaults, meterRegistry, raptorConfig, RequestLoggerFactory.createLogger(requestLogFile), new TileRendererManager(graph, routeRequestDefaults.preferences()), vectorTileLayers, worldEnvelopeService, vehiclePositionService, vehicleRentalService, rideHailingServices, traverseVisitor, flexConfig);
    }

    @Override
    public RouteRequest defaultRouteRequest() {
        if (this.routeRequest == null) {
            this.routeRequest = this.routeRequestDefaults.copyWithDateTimeNow();
        }
        return this.routeRequest;
    }

    @Override
    public Locale defaultLocale() {
        return this.routeRequestDefaults.locale();
    }

    @Override
    public RaptorConfig<TripSchedule> raptorConfig() {
        return this.raptorConfig;
    }

    @Override
    public Graph graph() {
        return this.graph;
    }

    @Override
    public TransitService transitService() {
        return this.transitService;
    }

    @Override
    public RoutingService routingService() {
        return new DefaultRoutingService(this);
    }

    @Override
    public WorldEnvelopeService worldEnvelopeService() {
        return this.worldEnvelopeService;
    }

    @Override
    public VehiclePositionService vehiclePositionService() {
        return this.vehiclePositionService;
    }

    @Override
    public VehicleRentalService vehicleRentalService() {
        return this.vehicleRentalService;
    }

    @Override
    public TransitTuningParameters transitTuningParameters() {
        return this.transitRoutingConfig;
    }

    @Override
    public RaptorTuningParameters raptorTuningParameters() {
        return this.transitRoutingConfig;
    }

    @Override
    public List<RideHailingService> rideHailingServices() {
        return this.rideHailingServices;
    }

    @Override
    public MeterRegistry meterRegistry() {
        return this.meterRegistry;
    }

    @Override
    public Logger requestLogger() {
        return this.requestLogger;
    }

    @Override
    public TileRendererManager tileRendererManager() {
        return this.tileRendererManager;
    }

    public TraverseVisitor traverseVisitor() {
        return this.traverseVisitor;
    }

    @Override
    public FlexConfig flexConfig() {
        return this.flexConfig;
    }

    @Override
    public VectorTilesResource.LayersParameters<VectorTilesResource.LayerType> vectorTileLayers() {
        return this.vectorTileLayers;
    }
}

