/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.standalone.server;

import jakarta.ws.rs.container.ContainerRequestContext;
import jakarta.ws.rs.container.ContainerRequestFilter;
import jakarta.ws.rs.container.ContainerResponseContext;
import jakarta.ws.rs.container.ContainerResponseFilter;
import jakarta.ws.rs.core.MultivaluedMap;
import jakarta.ws.rs.core.Response;
import java.io.IOException;

class CorsFilter
implements ContainerRequestFilter,
ContainerResponseFilter {
    CorsFilter() {
    }

    public void filter(ContainerRequestContext requestContext) throws IOException {
        if ("OPTIONS".equals(requestContext.getMethod())) {
            Response.ResponseBuilder preflightResponse = Response.status((Response.Status)Response.Status.OK);
            if (requestContext.getHeaderString("Access-Control-Request-Headers") != null) {
                preflightResponse.header("Access-Control-Allow-Headers", (Object)requestContext.getHeaderString("Access-Control-Request-Headers"));
            }
            if (requestContext.getHeaderString("Access-Control-Request-Method") != null) {
                preflightResponse.header("Access-Control-Allow-Method", (Object)"GET,POST");
            }
            preflightResponse.header("Access-Control-Max-Age", (Object)"3600");
            requestContext.abortWith(preflightResponse.build());
        }
    }

    public void filter(ContainerRequestContext request, ContainerResponseContext response) throws IOException {
        String origin = request.getHeaderString("Origin");
        MultivaluedMap headers = response.getHeaders();
        headers.add((Object)"Access-Control-Allow-Origin", (Object)origin);
        boolean secureTransport = request.getSecurityContext().isSecure();
        headers.add((Object)"Access-Control-Allow-Credentials", (Object)secureTransport);
    }
}

