/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.standalone.configure;

import dagger.BindsInstance;
import dagger.Component;
import jakarta.inject.Singleton;
import javax.annotation.Nullable;
import org.opentripplanner.ext.ridehailing.configure.RideHailingServicesModule;
import org.opentripplanner.graph_builder.issue.api.DataImportIssueSummary;
import org.opentripplanner.raptor.configure.RaptorConfig;
import org.opentripplanner.routing.algorithm.raptoradapter.transit.TripSchedule;
import org.opentripplanner.routing.graph.Graph;
import org.opentripplanner.service.vehiclepositions.VehiclePositionRepository;
import org.opentripplanner.service.vehiclepositions.VehiclePositionService;
import org.opentripplanner.service.vehiclepositions.configure.VehiclePositionsRepositoryModule;
import org.opentripplanner.service.vehiclepositions.configure.VehiclePositionsServiceModule;
import org.opentripplanner.service.vehiclerental.VehicleRentalRepository;
import org.opentripplanner.service.vehiclerental.VehicleRentalService;
import org.opentripplanner.service.vehiclerental.configure.VehicleRentalRepositoryModule;
import org.opentripplanner.service.vehiclerental.configure.VehicleRentalServiceModule;
import org.opentripplanner.service.worldenvelope.WorldEnvelopeRepository;
import org.opentripplanner.service.worldenvelope.WorldEnvelopeService;
import org.opentripplanner.service.worldenvelope.configure.WorldEnvelopeServiceModule;
import org.opentripplanner.standalone.api.OtpServerRequestContext;
import org.opentripplanner.standalone.config.ConfigModel;
import org.opentripplanner.standalone.config.configure.ConfigModule;
import org.opentripplanner.standalone.configure.ConstructApplicationModule;
import org.opentripplanner.standalone.server.MetricsLogging;
import org.opentripplanner.transit.configure.TransitModule;
import org.opentripplanner.transit.service.TransitModel;
import org.opentripplanner.transit.service.TransitService;
import org.opentripplanner.visualizer.GraphVisualizer;

@Singleton
@Component(modules={ConfigModule.class, TransitModule.class, WorldEnvelopeServiceModule.class, VehiclePositionsServiceModule.class, VehiclePositionsRepositoryModule.class, VehicleRentalServiceModule.class, VehicleRentalRepositoryModule.class, ConstructApplicationModule.class, RideHailingServicesModule.class})
public interface ConstructApplicationFactory {
    public ConfigModel config();

    public RaptorConfig<TripSchedule> raptorConfig();

    public Graph graph();

    public TransitModel transitModel();

    public WorldEnvelopeRepository worldEnvelopeRepository();

    public WorldEnvelopeService worldEnvelopeService();

    public VehiclePositionRepository vehiclePositionRepository();

    public VehiclePositionService vehiclePositionService();

    public VehicleRentalRepository vehicleRentalRepository();

    public VehicleRentalService vehicleRentalService();

    public DataImportIssueSummary dataImportIssueSummary();

    @Nullable
    public GraphVisualizer graphVisualizer();

    public TransitService transitService();

    public OtpServerRequestContext createServerContext();

    public MetricsLogging metricsLogging();

    @Component.Builder
    public static interface Builder {
        @BindsInstance
        public Builder configModel(ConfigModel var1);

        @BindsInstance
        public Builder graph(Graph var1);

        @BindsInstance
        public Builder transitModel(TransitModel var1);

        @BindsInstance
        public Builder graphVisualizer(@Nullable GraphVisualizer var1);

        @BindsInstance
        public Builder worldEnvelopeRepository(WorldEnvelopeRepository var1);

        @BindsInstance
        public Builder dataImportIssueSummary(DataImportIssueSummary var1);

        public ConstructApplicationFactory build();
    }
}

