/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.standalone.config.sandbox;

import java.time.Duration;
import org.opentripplanner.standalone.config.framework.json.NodeAdapter;
import org.opentripplanner.standalone.config.framework.json.OtpVersion;

public class FlexConfig {
    public static final FlexConfig DEFAULT = new FlexConfig();
    public static final String ACCESS_EGRESS_DESCRIPTION = "If you have multiple overlapping flex zones the high default value can lead to performance problems.\nA lower value means faster routing.\n\nDepending on your service this might be what you want to do anyway: many flex services are used\nby passengers with mobility problems so offering a long walk might be problematic. In other words,\nif you can walk 45 minutes to a flex stop/zone you're unlikely to be the target audience for those\nservices.\n";
    private final Duration maxTransferDuration;
    private final Duration maxFlexTripDuration;
    private final Duration maxAccessWalkDuration;
    private final Duration maxEgressWalkDuration;

    private FlexConfig() {
        this.maxTransferDuration = Duration.ofMinutes(5L);
        this.maxFlexTripDuration = Duration.ofMinutes(45L);
        this.maxAccessWalkDuration = Duration.ofMinutes(45L);
        this.maxEgressWalkDuration = Duration.ofMinutes(45L);
    }

    public FlexConfig(NodeAdapter root, String parameterName) {
        NodeAdapter json = root.of(parameterName).since(OtpVersion.V2_1).summary("Configuration for flex routing.").asObject();
        this.maxTransferDuration = json.of("maxTransferDuration").since(OtpVersion.V2_3).summary("How long should a passenger be allowed to walk after getting out of a flex vehicle and transferring to a flex or transit one.").description("This was mainly introduced to improve performance which is also the reason for not\nusing the existing value with the same name: fixed schedule transfers are computed\nduring the graph build but flex ones are calculated at request time and are more\nsensitive to slowdown.\n\nA lower value means that the routing is faster.\n").asDuration(FlexConfig.DEFAULT.maxTransferDuration);
        this.maxFlexTripDuration = json.of("maxFlexTripDuration").since(OtpVersion.V2_3).summary("How long can a non-scheduled flex trip at maximum be.").description("This is used for all trips which are of type `UnscheduledTrip`. The value includes the access/egress duration to the boarding/alighting of the flex trip, as well as the connection to the transit stop.").asDuration(FlexConfig.DEFAULT.maxFlexTripDuration);
        this.maxAccessWalkDuration = json.of("maxAccessWalkDuration").since(OtpVersion.V2_3).summary("The maximum duration the passenger will be allowed to walk to reach a flex stop or zone.").description(ACCESS_EGRESS_DESCRIPTION).asDuration(FlexConfig.DEFAULT.maxAccessWalkDuration);
        this.maxEgressWalkDuration = json.of("maxEgressWalkDuration").since(OtpVersion.V2_3).summary("The maximum duration the passenger will be allowed to walk after leaving the flex vehicle at the final destination.").description(ACCESS_EGRESS_DESCRIPTION).asDuration(FlexConfig.DEFAULT.maxEgressWalkDuration);
    }

    public Duration maxFlexTripDuration() {
        return this.maxFlexTripDuration;
    }

    public Duration maxTransferDuration() {
        return this.maxTransferDuration;
    }

    public Duration maxAccessWalkDuration() {
        return this.maxAccessWalkDuration;
    }

    public Duration maxEgressWalkDuration() {
        return this.maxEgressWalkDuration;
    }
}

