/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.standalone.config.routerconfig.updaters;

import java.time.ZoneId;
import java.util.ArrayList;
import java.util.Set;
import org.opentripplanner.ext.vehicleparking.bikely.BikelyUpdaterParameters;
import org.opentripplanner.ext.vehicleparking.hslpark.HslParkUpdaterParameters;
import org.opentripplanner.ext.vehicleparking.parkapi.ParkAPIUpdaterParameters;
import org.opentripplanner.standalone.config.framework.json.NodeAdapter;
import org.opentripplanner.standalone.config.framework.json.OtpVersion;
import org.opentripplanner.standalone.config.routerconfig.updaters.HttpHeadersConfig;
import org.opentripplanner.updater.vehicle_parking.VehicleParkingSourceType;
import org.opentripplanner.updater.vehicle_parking.VehicleParkingUpdaterParameters;

public class VehicleParkingUpdaterConfig {
    public static VehicleParkingUpdaterParameters create(String updaterRef, NodeAdapter c) {
        VehicleParkingSourceType sourceType = (VehicleParkingSourceType)((Object)c.of("sourceType").since(OtpVersion.V2_2).summary("The source of the vehicle updates.").asEnum(VehicleParkingSourceType.class));
        String feedId = c.of("feedId").since(OtpVersion.V2_2).summary("The name of the data source.").description("This will end up in the API responses as the feed id of of the parking lot.").asString(null);
        return switch (sourceType) {
            default -> throw new IncompatibleClassChangeError();
            case VehicleParkingSourceType.HSL_PARK -> new HslParkUpdaterParameters(updaterRef, c.of("facilitiesFrequencySec").since(OtpVersion.V2_2).summary("How often the facilities should be updated.").asInt(3600), c.of("facilitiesUrl").since(OtpVersion.V2_2).summary("URL of the facilities.").asString(null), feedId, sourceType, c.of("utilizationsFrequencySec").since(OtpVersion.V2_2).summary("How often the utilization should be updated.").asInt(600), c.of("utilizationsUrl").since(OtpVersion.V2_2).summary("URL of the utilization data.").asString(null), VehicleParkingUpdaterConfig.getTimeZone(c), c.of("hubsUrl").since(OtpVersion.V2_2).summary("Hubs URL").asString(null));
            case VehicleParkingSourceType.PARK_API, VehicleParkingSourceType.BICYCLE_PARK_API -> new ParkAPIUpdaterParameters(updaterRef, c.of("url").since(OtpVersion.V2_2).summary("URL of the resource.").asString(null), feedId, c.of("frequencySec").since(OtpVersion.V2_2).summary("How often to update the source.").asInt(60), HttpHeadersConfig.headers(c, OtpVersion.V2_2), new ArrayList<String>(c.of("tags").since(OtpVersion.V2_2).summary("Tags to add to the parking lots.").asStringSet(Set.of())), sourceType, VehicleParkingUpdaterConfig.getTimeZone(c));
            case VehicleParkingSourceType.BIKELY -> new BikelyUpdaterParameters(updaterRef, c.of("url").since(OtpVersion.V2_3).summary("URL of the locations endpoint.").asString(null), feedId, c.of("frequencySec").since(OtpVersion.V2_3).summary("How often to update the source.").asInt(60), HttpHeadersConfig.headers(c, OtpVersion.V2_3));
        };
    }

    private static ZoneId getTimeZone(NodeAdapter c) {
        return c.of("timeZone").since(OtpVersion.V2_2).summary("The time zone of the feed.").description("Used for converting abstract opening hours into concrete points in time.").asZoneId(null);
    }
}

