/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.standalone.config.routerconfig.updaters;

import org.opentripplanner.standalone.config.framework.json.NodeAdapter;
import org.opentripplanner.standalone.config.framework.json.OtpVersion;
import org.opentripplanner.standalone.config.routerconfig.updaters.HttpHeadersConfig;
import org.opentripplanner.updater.spi.HttpHeaders;
import org.opentripplanner.updater.trip.BackwardsDelayPropagationType;
import org.opentripplanner.updater.trip.PollingTripUpdaterParameters;

public class PollingTripUpdaterConfig {
    public static PollingTripUpdaterParameters create(String configRef, NodeAdapter c) {
        String url = c.of("url").since(OtpVersion.V1_5).summary("The URL of the GTFS-RT resource.").description("`file:` URLs are also supported if you want to read a file from the local disk.").asString();
        HttpHeaders headers = HttpHeadersConfig.headers(c, OtpVersion.V2_3);
        return new PollingTripUpdaterParameters(configRef, c.of("frequencySec").since(OtpVersion.V1_5).summary("How often the data should be downloaded in seconds.").asInt(60), c.of("fuzzyTripMatching").since(OtpVersion.V1_5).summary("If the trips should be matched fuzzily.").asBoolean(false), c.of("backwardsDelayPropagationType").since(OtpVersion.V2_2).summary("How backwards propagation should be handled.").description("  REQUIRED_NO_DATA:\n  Default value. Only propagates delays backwards when it is required to ensure that the times\n  are increasing, and it sets the NO_DATA flag on the stops so these automatically updated times\n  are not exposed through APIs.\n\n  REQUIRED:\n  Only propagates delays backwards when it is required to ensure that the times are increasing.\n  The updated times are exposed through APIs.\n\n  ALWAYS\n  Propagates delays backwards on stops with no estimates regardless if it's required or not.\n  The updated times are exposed through APIs.\n").asEnum(BackwardsDelayPropagationType.REQUIRED_NO_DATA), c.of("feedId").since(OtpVersion.V1_5).summary("Which feed the updates apply to.").asString(null), url, headers);
    }
}

