/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.standalone.config.routerconfig;

import java.lang.invoke.MethodHandle;
import java.lang.runtime.ObjectMethods;
import java.util.Collection;
import java.util.List;
import org.opentripplanner.ext.vectortiles.VectorTilesResource;
import org.opentripplanner.inspector.vector.LayerParameters;
import org.opentripplanner.standalone.config.framework.json.NodeAdapter;
import org.opentripplanner.standalone.config.framework.json.OtpVersion;

public class VectorTileConfig
implements VectorTilesResource.LayersParameters<VectorTilesResource.LayerType> {
    List<LayerParameters<VectorTilesResource.LayerType>> layers;

    public VectorTileConfig(Collection<? extends LayerParameters<VectorTilesResource.LayerType>> layers) {
        this.layers = List.copyOf(layers);
    }

    @Override
    public List<LayerParameters<VectorTilesResource.LayerType>> layers() {
        return this.layers;
    }

    public static VectorTileConfig mapVectorTilesParameters(NodeAdapter root, String vectorTileLayers) {
        return new VectorTileConfig(root.of(vectorTileLayers).since(OtpVersion.V2_0).summary("Configuration of the individual layers for the Mapbox vector tiles.").asObjects(VectorTileConfig::mapLayer));
    }

    public static Layer mapLayer(NodeAdapter node) {
        return new Layer(node.of("name").since(OtpVersion.V2_0).summary("Used in the url to fetch tiles, and as the layer name in the vector tiles.").asString(), (VectorTilesResource.LayerType)((Object)node.of("type").since(OtpVersion.V2_0).summary("Type of the layer.").asEnum(VectorTilesResource.LayerType.class)), node.of("mapper").since(OtpVersion.V2_0).summary("Describes the mapper converting from the OTP model entities to the vector tile properties.").description("Currently `Digitransit` is supported for all layer types.").asString(), node.of("maxZoom").since(OtpVersion.V2_0).summary("Maximum zoom levels the layer is active for.").asInt(20), node.of("minZoom").since(OtpVersion.V2_0).summary("Minimum zoom levels the layer is active for.").asInt(9), node.of("cacheMaxSeconds").since(OtpVersion.V2_0).summary("Sets the cache header in the response.").description("The lowest value of the layers included is selected.").asInt(-1), node.of("expansionFactor").since(OtpVersion.V2_0).summary("How far outside its boundaries should the tile contain information.").description("The value is a fraction of the tile size. If you are having problem with icons and shapes being clipped at tile edges, then increase this number.").asDouble(0.25));
    }

    static final class Layer
    extends Record
    implements LayerParameters<VectorTilesResource.LayerType> {
        private final String name;
        private final VectorTilesResource.LayerType type;
        private final String mapper;
        private final int maxZoom;
        private final int minZoom;
        private final int cacheMaxSeconds;
        private final double expansionFactor;

        Layer(String name, VectorTilesResource.LayerType type, String mapper, int maxZoom, int minZoom, int cacheMaxSeconds, double expansionFactor) {
            this.name = name;
            this.type = type;
            this.mapper = mapper;
            this.maxZoom = maxZoom;
            this.minZoom = minZoom;
            this.cacheMaxSeconds = cacheMaxSeconds;
            this.expansionFactor = expansionFactor;
        }

        @Override
        public final String toString() {
            return ObjectMethods.bootstrap("toString", new MethodHandle[]{Layer.class, "name;type;mapper;maxZoom;minZoom;cacheMaxSeconds;expansionFactor", "name", "type", "mapper", "maxZoom", "minZoom", "cacheMaxSeconds", "expansionFactor"}, this);
        }

        @Override
        public final int hashCode() {
            return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{Layer.class, "name;type;mapper;maxZoom;minZoom;cacheMaxSeconds;expansionFactor", "name", "type", "mapper", "maxZoom", "minZoom", "cacheMaxSeconds", "expansionFactor"}, this);
        }

        @Override
        public final boolean equals(Object o) {
            return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{Layer.class, "name;type;mapper;maxZoom;minZoom;cacheMaxSeconds;expansionFactor", "name", "type", "mapper", "maxZoom", "minZoom", "cacheMaxSeconds", "expansionFactor"}, this, o);
        }

        @Override
        public String name() {
            return this.name;
        }

        @Override
        public VectorTilesResource.LayerType type() {
            return this.type;
        }

        @Override
        public String mapper() {
            return this.mapper;
        }

        @Override
        public int maxZoom() {
            return this.maxZoom;
        }

        @Override
        public int minZoom() {
            return this.minZoom;
        }

        @Override
        public int cacheMaxSeconds() {
            return this.cacheMaxSeconds;
        }

        @Override
        public double expansionFactor() {
            return this.expansionFactor;
        }
    }
}

