/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.standalone.config.framework.project;

import java.util.HashMap;
import java.util.Map;
import java.util.function.Function;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.opentripplanner.framework.application.OtpAppException;
import org.opentripplanner.model.projectinfo.OtpProjectInfo;

public class EnvironmentVariableReplacer {
    private static final Pattern PATTERN = Pattern.compile("\\$\\{([.\\w]+)}");
    private static final Map<String, String> PROJECT_INFO = Map.ofEntries(Map.entry("maven.version", OtpProjectInfo.projectInfo().version.version), Map.entry("maven.version.short", OtpProjectInfo.projectInfo().version.unqualifiedVersion()), Map.entry("maven.version.major", Integer.toString(OtpProjectInfo.projectInfo().version.major)), Map.entry("maven.version.minor", Integer.toString(OtpProjectInfo.projectInfo().version.minor)), Map.entry("maven.version.patch", Integer.toString(OtpProjectInfo.projectInfo().version.patch)), Map.entry("maven.version.qualifier", OtpProjectInfo.projectInfo().version.qualifier), Map.entry("graph.file.header", OtpProjectInfo.projectInfo().graphFileHeaderInfo.asString()), Map.entry("otp.serialization.version.id", OtpProjectInfo.projectInfo().graphFileHeaderInfo.otpSerializationVersionId()), Map.entry("git.branch", OtpProjectInfo.projectInfo().versionControl.branch), Map.entry("git.commit", OtpProjectInfo.projectInfo().versionControl.commit), Map.entry("git.commit.timestamp", OtpProjectInfo.projectInfo().versionControl.commitTime));

    public static String insertEnvironmentVariables(String text, String source) {
        return EnvironmentVariableReplacer.insertVariables(text, source, System::getenv);
    }

    public static String insertVariables(String text, String source, Function<String, String> getEnvVar) {
        HashMap<String, String> substitutions = new HashMap<String, String>();
        Matcher matcher = PATTERN.matcher(text);
        while (matcher.find()) {
            String subKey = matcher.group(0);
            String nameOnly = matcher.group(1);
            if (substitutions.containsKey(nameOnly)) continue;
            String value = getEnvVar.apply(nameOnly);
            if (value != null) {
                substitutions.put(subKey, value);
                continue;
            }
            if (PROJECT_INFO.containsKey(nameOnly)) {
                substitutions.put(subKey, PROJECT_INFO.get(nameOnly));
                continue;
            }
            throw new OtpAppException("Environment variable name '" + nameOnly + "' in config '" + source + "' not found in the system environment variables.");
        }
        for (Map.Entry entry : substitutions.entrySet()) {
            text = text.replace((CharSequence)entry.getKey(), (CharSequence)entry.getValue());
        }
        return text;
    }
}

