/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.standalone.config.framework.file;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.MissingNode;
import com.fasterxml.jackson.databind.node.TextNode;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.Set;
import javax.annotation.Nullable;
import org.opentripplanner.framework.application.OtpAppException;
import org.opentripplanner.standalone.config.framework.file.IncludeFileDirective;
import org.opentripplanner.standalone.config.framework.project.EnvironmentVariableReplacer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConfigFileLoader {
    private static final Logger LOG = LoggerFactory.getLogger(ConfigFileLoader.class);
    private static final Set<String> REDACT_KEYS = Set.of("secretKey", "accessKey", "gsCredentials");
    private final ObjectMapper mapper = new ObjectMapper();
    @Nullable
    private File configDir = null;
    @Nullable
    private String jsonFallback = null;

    private ConfigFileLoader() {
        this.mapper.configure(JsonParser.Feature.ALLOW_COMMENTS, true);
        this.mapper.configure(JsonParser.Feature.ALLOW_UNQUOTED_FIELD_NAMES, true);
    }

    public static ConfigFileLoader of() {
        return new ConfigFileLoader();
    }

    public ConfigFileLoader withConfigDir(File configDir) {
        this.configDir = ConfigFileLoader.assertConfigDirExist(configDir);
        return this;
    }

    public ConfigFileLoader withJsonFallback(String jsonFallback) {
        this.jsonFallback = jsonFallback;
        return this;
    }

    public static JsonNode nodeFromString(String json, String source) {
        return ConfigFileLoader.of().stringToJsonNode(json, source);
    }

    public JsonNode loadFromFile(String filename) {
        if (this.configDir == null) {
            if (this.jsonFallback != null) {
                return this.stringToJsonNode(this.jsonFallback, filename);
            }
            LOG.warn("Config '{}' not loaded, using defaults. Config directory not set.", (Object)filename);
            return MissingNode.getInstance();
        }
        return this.loadJsonFile(new File(this.configDir, filename));
    }

    private static String toRedactedString(JsonNode node) {
        JsonNode redactedNode = node.deepCopy();
        ConfigFileLoader.redactSecretsRecursive(redactedNode);
        return redactedNode.toPrettyString();
    }

    private static void redactSecretsRecursive(JsonNode node) {
        if (node.isObject()) {
            node.fields().forEachRemaining(entry -> {
                if (((JsonNode)entry.getValue()).isObject()) {
                    ConfigFileLoader.redactSecretsRecursive((JsonNode)entry.getValue());
                } else if (REDACT_KEYS.contains(entry.getKey())) {
                    entry.setValue(new TextNode("********"));
                }
            });
        }
    }

    private JsonNode loadJsonFile(File file) {
        JsonNode jsonNode;
        FileInputStream is = new FileInputStream(file);
        try {
            String configString = new String(is.readAllBytes(), StandardCharsets.UTF_8);
            JsonNode node = this.stringToJsonNode(configString, file.toString());
            LOG.info("Load JSON configuration file '{}'", (Object)file.getPath());
            LOG.info("Summarizing '{}': {}", (Object)file.getName(), (Object)ConfigFileLoader.toRedactedString(node));
            jsonNode = node;
        }
        catch (Throwable throwable) {
            try {
                try {
                    is.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (FileNotFoundException ex) {
                LOG.info("File '{}' is not present. Using default configuration.", (Object)file);
                return MissingNode.getInstance();
            }
            catch (IOException e) {
                LOG.error("Error while parsing JSON config file '{}': {}", (Object)file, (Object)e.getMessage());
                throw new RuntimeException(e.getLocalizedMessage(), e);
            }
        }
        is.close();
        return jsonNode;
    }

    private JsonNode stringToJsonNode(String jsonAsString, String source) {
        try {
            if (jsonAsString == null || jsonAsString.isBlank()) {
                return MissingNode.getInstance();
            }
            jsonAsString = IncludeFileDirective.includeFileDirective(this.configDir, jsonAsString, source);
            jsonAsString = EnvironmentVariableReplacer.insertEnvironmentVariables(jsonAsString, source);
            return this.mapper.readTree(jsonAsString);
        }
        catch (IOException ie) {
            LOG.error("Error while parsing config '{}'.", (Object)source, (Object)ie);
            throw new OtpAppException("Failed to load config: " + source);
        }
    }

    public static File assertConfigDirExist(File configDir) {
        if (configDir == null) {
            return null;
        }
        if (!configDir.isDirectory()) {
            throw new IllegalArgumentException(configDir + " is not a readable configuration directory.");
        }
        return configDir;
    }
}

