/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.standalone.config.buildconfig;

import org.opentripplanner.netex.config.NetexFeedParameters;
import org.opentripplanner.standalone.config.framework.json.NodeAdapter;
import org.opentripplanner.standalone.config.framework.json.OtpVersion;
import org.opentripplanner.standalone.config.framework.json.ParameterBuilder;

public class NetexConfig {
    public static NetexFeedParameters mapNetexDefaultParameters(NodeAdapter root, String parameterName) {
        NodeAdapter node = root.of(parameterName).since(OtpVersion.V2_2).summary("The netexDefaults section allows you to specify default properties for NeTEx files.").asObject();
        return NetexConfig.mapDefaultParameters(node);
    }

    static NetexFeedParameters mapNetexFeed(NodeAdapter feedNode, NetexFeedParameters original) {
        return NetexConfig.mapFilePatternParameters(feedNode, original).withFeedId(NetexConfig.readFeedId(feedNode).asString()).withSource(feedNode.of("source").since(OtpVersion.V2_2).summary("The unique URI pointing to the data file.").asUri()).build();
    }

    private static NetexFeedParameters mapDefaultParameters(NodeAdapter config) {
        String feedId = NetexConfig.readFeedId(config).asString(NetexFeedParameters.DEFAULT.feedId());
        return NetexConfig.mapFilePatternParameters(config, NetexFeedParameters.DEFAULT).withFeedId(feedId).build();
    }

    private static NetexFeedParameters.Builder mapFilePatternParameters(NodeAdapter config, NetexFeedParameters base) {
        NetexFeedParameters dft = NetexFeedParameters.DEFAULT;
        return base.copyOf().withSharedFilePattern(config.of("sharedFilePattern").since(OtpVersion.V2_0).summary("Pattern for matching shared NeTEx files in a NeTEx bundle.").description("This field is used to match *shared files*(zip file entries) in the module file. Shared\nfiles are loaded first. Then the rest of the files are grouped and loaded.\n\nThe pattern `\"shared-data.xml\"` matches `\"shared-data.xml\"`\n\nFile names are matched in the following order - and treated accordingly to the first match:\n\n - `ignoreFilePattern`\n - `sharedFilePattern`\n - `sharedGroupFilePattern`\n - `groupFilePattern`\n").docDefaultValue(dft.sharedFilePattern().pattern()).asPattern(base.sharedFilePattern().pattern())).withSharedGroupFilePattern(config.of("sharedGroupFilePattern").since(OtpVersion.V2_0).summary("Pattern for matching shared group NeTEx files in a NeTEx bundle.").description("This field is used to match *shared group files* in the module file(zip file entries).\nTypically this is used to group all files from one agency together.\n\n*Shared group files* are loaded after shared files, but before the matching group\nfiles. Each *group* of files are loaded as a unit, followed by next group.\n\nFiles are grouped together by the first group pattern in the regular expression.\n\nThe pattern `\"(\\w{3})-.*-shared\\.xml\"` matches `\"RUT-shared.xml\"` with group `\"RUT\"`.\n").docDefaultValue(dft.sharedGroupFilePattern().pattern()).asPattern(base.sharedGroupFilePattern().pattern())).withGroupFilePattern(config.of("groupFilePattern").since(OtpVersion.V2_0).summary("Pattern for matching group NeTEx files.").description("This field is used to match *group files* in the module file(zip file entries).\n*group files* are loaded right the after *shared group files* are loaded.\nFiles are grouped together by the first group pattern in the regular expression.\nThe pattern `\"(\\w{3})-.*\\.xml\"` matches `\"RUT-Line-208-Hagalia-Nevlunghavn.xml\"`\nwith group `\"RUT\"`.\n").docDefaultValue(dft.groupFilePattern().pattern()).asPattern(base.groupFilePattern().pattern())).withIgnoreFilePattern(config.of("ignoreFilePattern").since(OtpVersion.V2_0).summary("Pattern for matching ignored files in a NeTEx bundle.").description("This field is used to exclude matching *files* in the module file(zip file entries).\nThe *ignored* files are *not* loaded.\n").docDefaultValue(dft.ignoreFilePattern().pattern()).asPattern(base.ignoreFilePattern().pattern())).withNoTransfersOnIsolatedStops(config.of("noTransfersOnIsolatedStops").since(OtpVersion.V2_2).summary("Whether we should allow transfers to and from StopPlaces marked with LimitedUse.ISOLATED").docDefaultValue(dft.noTransfersOnIsolatedStops()).asBoolean(base.noTransfersOnIsolatedStops())).addFerryIdsNotAllowedForBicycle(config.of("ferryIdsNotAllowedForBicycle").since(OtpVersion.V2_0).summary("List ferries which do not allow bikes.").description("Bicycles are allowed on most ferries however the Nordic profile doesn't contain a place\nwhere bicycle conveyance can be defined.\n\nFor this reason we allow bicycles on ferries by default and allow to override the rare\ncase where this is not the case.\n").docDefaultValue(dft.ferryIdsNotAllowedForBicycle()).asStringSet(base.ferryIdsNotAllowedForBicycle())).withIgnoreFareFrame(config.of("ignoreFareFrame").since(OtpVersion.V2_3).summary("Ignore contents of the FareFrame").docDefaultValue(base.ignoreFareFrame()).asBoolean(base.ignoreFareFrame()));
    }

    private static ParameterBuilder readFeedId(NodeAdapter config) {
        return config.of("feedId").since(OtpVersion.V2_2).summary("This field is used to identify the specific NeTEx feed. It is used instead of the feed_id field in GTFS file feed_info.txt.");
    }
}

