/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.standalone.api;

import io.micrometer.core.instrument.MeterRegistry;
import java.util.List;
import java.util.Locale;
import org.opentripplanner.astar.spi.TraverseVisitor;
import org.opentripplanner.ext.dataoverlay.routing.DataOverlayContext;
import org.opentripplanner.ext.ridehailing.RideHailingService;
import org.opentripplanner.ext.vectortiles.VectorTilesResource;
import org.opentripplanner.framework.application.OTPFeature;
import org.opentripplanner.inspector.raster.TileRendererManager;
import org.opentripplanner.raptor.api.request.RaptorTuningParameters;
import org.opentripplanner.raptor.configure.RaptorConfig;
import org.opentripplanner.routing.algorithm.raptoradapter.transit.TransitTuningParameters;
import org.opentripplanner.routing.algorithm.raptoradapter.transit.TripSchedule;
import org.opentripplanner.routing.api.RoutingService;
import org.opentripplanner.routing.api.request.RouteRequest;
import org.opentripplanner.routing.graph.Graph;
import org.opentripplanner.routing.graphfinder.GraphFinder;
import org.opentripplanner.service.vehiclepositions.VehiclePositionService;
import org.opentripplanner.service.vehiclerental.VehicleRentalService;
import org.opentripplanner.service.worldenvelope.WorldEnvelopeService;
import org.opentripplanner.standalone.config.sandbox.FlexConfig;
import org.opentripplanner.street.model.edge.Edge;
import org.opentripplanner.street.search.state.State;
import org.opentripplanner.transit.service.TransitService;
import org.slf4j.Logger;

public interface OtpServerRequestContext {
    public RouteRequest defaultRouteRequest();

    public Locale defaultLocale();

    public RaptorConfig<TripSchedule> raptorConfig();

    public Graph graph();

    public TransitService transitService();

    public RoutingService routingService();

    public WorldEnvelopeService worldEnvelopeService();

    public VehiclePositionService vehiclePositionService();

    public VehicleRentalService vehicleRentalService();

    public TransitTuningParameters transitTuningParameters();

    public RaptorTuningParameters raptorTuningParameters();

    public List<RideHailingService> rideHailingServices();

    public MeterRegistry meterRegistry();

    public Logger requestLogger();

    public TileRendererManager tileRendererManager();

    public TraverseVisitor<State, Edge> traverseVisitor();

    default public GraphFinder graphFinder() {
        return GraphFinder.getInstance(this.graph(), this.transitService()::findRegularStop);
    }

    public FlexConfig flexConfig();

    public VectorTilesResource.LayersParameters<VectorTilesResource.LayerType> vectorTileLayers();

    default public DataOverlayContext dataOverlayContext(RouteRequest request) {
        return OTPFeature.DataOverlay.isOnElseNull(() -> new DataOverlayContext(this.graph().dataOverlayParameterBindings, request.preferences().system().dataOverlay()));
    }
}

