/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.service.vehiclerental.street;

import org.locationtech.jts.geom.LineString;
import org.opentripplanner.framework.i18n.I18NString;
import org.opentripplanner.service.vehiclerental.street.VehicleRentalPlaceVertex;
import org.opentripplanner.street.model.edge.Edge;
import org.opentripplanner.street.model.vertex.StreetVertex;
import org.opentripplanner.street.search.state.State;
import org.opentripplanner.street.search.state.StateEditor;

public class StreetVehicleRentalLink
extends Edge {
    private final VehicleRentalPlaceVertex vehicleRentalPlaceVertex;

    public StreetVehicleRentalLink(StreetVertex fromv, VehicleRentalPlaceVertex tov) {
        super(fromv, tov);
        this.vehicleRentalPlaceVertex = tov;
    }

    public StreetVehicleRentalLink(VehicleRentalPlaceVertex fromv, StreetVertex tov) {
        super(fromv, tov);
        this.vehicleRentalPlaceVertex = fromv;
    }

    @Override
    public String toString() {
        return "StreetVehicleRentalLink(" + this.fromv + " -> " + this.tov + ")";
    }

    @Override
    public State traverse(State s0) {
        if (s0.getBackEdge() instanceof StreetVehicleRentalLink) {
            return null;
        }
        if (this.vehicleRentalPlaceVertex.getStation().networkIsNotAllowed(s0.getRequest().rental())) {
            return null;
        }
        StateEditor s1 = s0.edit(this);
        s1.incrementWeight(1.0);
        s1.setBackMode(null);
        return s1.makeState();
    }

    @Override
    public I18NString getName() {
        return this.vehicleRentalPlaceVertex.getName();
    }

    @Override
    public LineString getGeometry() {
        return null;
    }

    @Override
    public double getDistanceMeters() {
        return 0.0;
    }
}

