/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.service.vehiclerental.street;

import java.util.EnumSet;
import java.util.List;
import java.util.Set;
import org.opentripplanner.service.vehiclerental.model.GeofencingZone;
import org.opentripplanner.street.model.RentalRestrictionExtension;
import org.opentripplanner.street.search.state.State;

public final class GeofencingZoneExtension
implements RentalRestrictionExtension {
    private final GeofencingZone zone;

    public GeofencingZoneExtension(GeofencingZone zone) {
        this.zone = zone;
    }

    public GeofencingZone zone() {
        return this.zone;
    }

    @Override
    public boolean traversalBanned(State state) {
        if (state.isRentingVehicle()) {
            return this.zone.traversalBanned() && (state.unknownRentalNetwork() || this.zone.id().getFeedId().equals(state.getVehicleRentalNetwork()));
        }
        return false;
    }

    @Override
    public boolean dropOffBanned(State state) {
        if (state.isRentingVehicle()) {
            return this.zone.dropOffBanned() && (state.unknownRentalNetwork() || this.zone.id().getFeedId().equals(state.getVehicleRentalNetwork()));
        }
        return false;
    }

    @Override
    public Set<RentalRestrictionExtension.RestrictionType> debugTypes() {
        EnumSet<RentalRestrictionExtension.RestrictionType> set = EnumSet.noneOf(RentalRestrictionExtension.RestrictionType.class);
        if (this.zone.traversalBanned()) {
            set.add(RentalRestrictionExtension.RestrictionType.NO_TRAVERSAL);
        }
        if (this.zone.dropOffBanned()) {
            set.add(RentalRestrictionExtension.RestrictionType.NO_DROP_OFF);
        }
        return set;
    }

    @Override
    public List<RentalRestrictionExtension> toList() {
        return List.of(this);
    }

    @Override
    public List<String> networks() {
        return List.of(this.zone.id().getFeedId());
    }

    @Override
    public boolean hasRestrictions() {
        return true;
    }

    @Override
    public Set<String> noDropOffNetworks() {
        if (this.zone.dropOffBanned()) {
            return Set.of(this.zone.id().getFeedId());
        }
        return Set.of();
    }

    public String toString() {
        return this.zone.id().toString();
    }
}

