/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.service.vehiclerental.street;

import java.util.EnumSet;
import java.util.List;
import java.util.Set;
import org.opentripplanner.street.model.RentalRestrictionExtension;
import org.opentripplanner.street.search.state.State;

public final class BusinessAreaBorder
implements RentalRestrictionExtension {
    private final String network;

    public BusinessAreaBorder(String network) {
        this.network = network;
    }

    @Override
    public boolean traversalBanned(State state) {
        if (state.getRequest().arriveBy()) {
            return state.isRentingVehicle();
        }
        return state.isRentingVehicle() && this.network.equals(state.getVehicleRentalNetwork());
    }

    @Override
    public boolean dropOffBanned(State state) {
        return false;
    }

    @Override
    public Set<RentalRestrictionExtension.RestrictionType> debugTypes() {
        return EnumSet.of(RentalRestrictionExtension.RestrictionType.BUSINESS_AREA_BORDER);
    }

    @Override
    public List<RentalRestrictionExtension> toList() {
        return List.of(this);
    }

    @Override
    public boolean hasRestrictions() {
        return true;
    }

    @Override
    public Set<String> noDropOffNetworks() {
        return Set.of();
    }

    @Override
    public List<String> networks() {
        return List.of(this.network);
    }
}

