/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.service.vehiclerental.model;

import java.util.Set;
import org.opentripplanner.framework.i18n.I18NString;
import org.opentripplanner.routing.api.request.request.VehicleRentalRequest;
import org.opentripplanner.service.vehiclerental.model.VehicleRentalStationUris;
import org.opentripplanner.street.model.RentalFormFactor;
import org.opentripplanner.transit.model.framework.FeedScopedId;

public interface VehicleRentalPlace {
    public FeedScopedId getId();

    public String getStationId();

    public String getNetwork();

    public I18NString getName();

    public double getLongitude();

    public double getLatitude();

    public int getVehiclesAvailable();

    public int getSpacesAvailable();

    public Integer getCapacity();

    public boolean isAllowDropoff();

    public boolean overloadingAllowed();

    public boolean isAllowPickup();

    public boolean allowPickupNow();

    public boolean allowDropoffNow();

    public boolean isFloatingVehicle();

    public boolean isCarStation();

    public Set<RentalFormFactor> getAvailablePickupFormFactors(boolean var1);

    public Set<RentalFormFactor> getAvailableDropoffFormFactors(boolean var1);

    public boolean isArrivingInRentalVehicleAtDestinationAllowed();

    public boolean isRealTimeData();

    public VehicleRentalStationUris getRentalUris();

    default public boolean networkIsNotAllowed(VehicleRentalRequest request) {
        if (!(this.getNetwork() != null || request.allowedNetworks().isEmpty() && request.bannedNetworks().isEmpty())) {
            return false;
        }
        if (request.bannedNetworks().contains(this.getNetwork())) {
            return true;
        }
        if (request.allowedNetworks().isEmpty()) {
            return false;
        }
        return !request.allowedNetworks().contains(this.getNetwork());
    }
}

