/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.service.vehiclerental.internal;

import jakarta.inject.Inject;
import jakarta.inject.Singleton;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.Envelope;
import org.opentripplanner.service.vehiclerental.VehicleRentalRepository;
import org.opentripplanner.service.vehiclerental.VehicleRentalService;
import org.opentripplanner.service.vehiclerental.model.VehicleRentalPlace;
import org.opentripplanner.service.vehiclerental.model.VehicleRentalStation;
import org.opentripplanner.service.vehiclerental.model.VehicleRentalVehicle;
import org.opentripplanner.street.model.RentalFormFactor;
import org.opentripplanner.transit.model.framework.FeedScopedId;

@Singleton
public class DefaultVehicleRentalService
implements VehicleRentalService,
VehicleRentalRepository {
    private final Map<FeedScopedId, VehicleRentalPlace> rentalPlaces = new HashMap<FeedScopedId, VehicleRentalPlace>();

    @Inject
    public DefaultVehicleRentalService() {
    }

    @Override
    public Collection<VehicleRentalPlace> getVehicleRentalPlaces() {
        return this.rentalPlaces.values();
    }

    @Override
    public VehicleRentalPlace getVehicleRentalPlace(FeedScopedId id) {
        return this.rentalPlaces.get(id);
    }

    @Override
    public List<VehicleRentalVehicle> getVehicleRentalVehicles() {
        return this.rentalPlaces.values().stream().filter(vehicleRentalPlace -> vehicleRentalPlace instanceof VehicleRentalVehicle).map(VehicleRentalVehicle.class::cast).toList();
    }

    @Override
    public VehicleRentalVehicle getVehicleRentalVehicle(FeedScopedId id) {
        VehicleRentalPlace vehicleRentalPlace = this.rentalPlaces.get(id);
        return vehicleRentalPlace instanceof VehicleRentalVehicle ? (VehicleRentalVehicle)vehicleRentalPlace : null;
    }

    @Override
    public List<VehicleRentalStation> getVehicleRentalStations() {
        return this.rentalPlaces.values().stream().filter(vehicleRentalPlace -> vehicleRentalPlace instanceof VehicleRentalStation).map(VehicleRentalStation.class::cast).toList();
    }

    @Override
    public VehicleRentalStation getVehicleRentalStation(FeedScopedId id) {
        VehicleRentalPlace vehicleRentalPlace = this.rentalPlaces.get(id);
        return vehicleRentalPlace instanceof VehicleRentalStation ? (VehicleRentalStation)vehicleRentalPlace : null;
    }

    @Override
    public void addVehicleRentalStation(VehicleRentalPlace vehicleRentalStation) {
        this.rentalPlaces.remove(vehicleRentalStation.getId());
        this.rentalPlaces.put(vehicleRentalStation.getId(), vehicleRentalStation);
    }

    @Override
    public void removeVehicleRentalStation(FeedScopedId vehicleRentalStationId) {
        this.rentalPlaces.remove(vehicleRentalStationId);
    }

    @Override
    public boolean hasRentalBikes() {
        return this.rentalPlaces.values().stream().anyMatch(place -> {
            if (place instanceof VehicleRentalVehicle) {
                VehicleRentalVehicle vehicle = (VehicleRentalVehicle)place;
                return vehicle.vehicleType.formFactor == RentalFormFactor.BICYCLE;
            }
            if (place instanceof VehicleRentalStation) {
                VehicleRentalStation station = (VehicleRentalStation)place;
                return station.vehicleTypesAvailable.keySet().stream().anyMatch(t -> t.formFactor == RentalFormFactor.BICYCLE);
            }
            return false;
        });
    }

    @Override
    public List<VehicleRentalPlace> getVehicleRentalStationForEnvelope(double minLon, double minLat, double maxLon, double maxLat) {
        Envelope envelope = new Envelope(new Coordinate(minLon, minLat), new Coordinate(maxLon, maxLat));
        return this.rentalPlaces.values().stream().filter(b -> envelope.contains(new Coordinate(b.getLongitude(), b.getLatitude()))).toList();
    }
}

