/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.service.vehiclepositions.internal;

import jakarta.inject.Inject;
import jakarta.inject.Singleton;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.opentripplanner.service.vehiclepositions.VehiclePositionRepository;
import org.opentripplanner.service.vehiclepositions.VehiclePositionService;
import org.opentripplanner.service.vehiclepositions.model.RealtimeVehiclePosition;
import org.opentripplanner.transit.model.network.TripPattern;

@Singleton
public class DefaultVehiclePositionService
implements VehiclePositionService,
VehiclePositionRepository {
    private final Map<TripPattern, List<RealtimeVehiclePosition>> positions = new ConcurrentHashMap<TripPattern, List<RealtimeVehiclePosition>>();

    @Inject
    public DefaultVehiclePositionService() {
    }

    @Override
    public void setVehiclePositions(TripPattern pattern, List<RealtimeVehiclePosition> updates) {
        this.positions.put(pattern, List.copyOf(updates));
    }

    @Override
    public void clearVehiclePositions(TripPattern pattern) {
        this.positions.remove(pattern);
    }

    @Override
    public List<RealtimeVehiclePosition> getVehiclePositions(TripPattern pattern) {
        return this.positions.getOrDefault(pattern, List.of());
    }
}

