/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.routing.util;

public record DiffEntry<T>(T left, T right) {
    public T element() {
        return this.rightOnly() ? this.right : this.left;
    }

    public boolean leftOnly() {
        return this.right == null;
    }

    public boolean rightOnly() {
        return this.left == null;
    }

    public boolean isEqual() {
        return this.left != null && this.right != null;
    }

    public String status(String equal, String left, String right) {
        return this.leftOnly() ? left : (this.rightOnly() ? right : equal);
    }

    @Override
    public String toString() {
        if (this.isEqual()) {
            return "(eq: " + this.element() + ")";
        }
        if (this.leftOnly()) {
            return "(left: " + this.left + ")";
        }
        return "(right: " + this.right + ")";
    }

    static <T> DiffEntry<T> ofLeft(T left) {
        return new DiffEntry<Object>(left, null);
    }

    static <T> DiffEntry<T> ofRight(T right) {
        return new DiffEntry<Object>(null, right);
    }

    static <T> DiffEntry<T> ofEqual(T left, T right) {
        return new DiffEntry<T>(left, right);
    }
}

