/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.routing.graphfinder;

import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import org.opentripplanner.astar.model.GraphPath;
import org.opentripplanner.street.model.edge.Edge;
import org.opentripplanner.street.search.state.State;
import org.opentripplanner.transit.model.site.StopLocation;

public class NearbyStop
implements Comparable<NearbyStop> {
    public final StopLocation stop;
    public final double distance;
    public final List<Edge> edges;
    public final State state;

    public NearbyStop(StopLocation stop, double distance, List<Edge> edges, State state) {
        this.stop = stop;
        this.distance = distance;
        this.edges = edges;
        this.state = state;
    }

    public static NearbyStop nearbyStopForState(State state, StopLocation stop) {
        double effectiveWalkDistance = 0.0;
        GraphPath graphPath = new GraphPath(state);
        ArrayList<Edge> edges = new ArrayList<Edge>();
        for (Edge edge : graphPath.edges) {
            effectiveWalkDistance += edge.getEffectiveWalkDistance();
            edges.add(edge);
        }
        return new NearbyStop(stop, effectiveWalkDistance, edges, state);
    }

    @Override
    public int compareTo(NearbyStop that) {
        if (this.state == null != (that.state == null)) {
            throw new IllegalStateException("Only NearbyStops which both contain or lack a state may be compared.");
        }
        if (this.state != null) {
            return (int)this.state.getWeight() - (int)that.state.getWeight();
        }
        return (int)this.distance - (int)that.distance;
    }

    public int hashCode() {
        return Objects.hash(this.stop, this.distance, this.edges, this.state);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        NearbyStop that = (NearbyStop)o;
        return Double.compare(that.distance, this.distance) == 0 && this.stop.equals(that.stop) && Objects.equals(this.edges, that.edges) && Objects.equals(this.state, that.state);
    }

    public String toString() {
        return String.format(Locale.ROOT, "stop %s at %.1f meters%s%s", this.stop, this.distance, this.edges != null ? " (" + this.edges.size() + " edges)" : "", this.state != null ? " w/state" : "");
    }
}

