/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.routing.api.request.request.filter;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.opentripplanner.framework.tostring.ToStringBuilder;
import org.opentripplanner.model.modes.AllowTransitModeFilter;
import org.opentripplanner.transit.model.basic.MainAndSubMode;
import org.opentripplanner.transit.model.framework.FeedScopedId;
import org.opentripplanner.transit.model.network.GroupOfRoutes;
import org.opentripplanner.transit.model.network.TripPattern;
import org.opentripplanner.transit.model.timetable.Trip;
import org.opentripplanner.transit.model.timetable.TripTimes;

public class SelectRequest
implements Serializable {
    private final List<MainAndSubMode> transportModes;
    private final AllowTransitModeFilter transportModeFilter;
    private final List<FeedScopedId> agencies;
    private final List<FeedScopedId> groupOfRoutes;
    private final List<FeedScopedId> routes;

    public static Builder of() {
        return new Builder();
    }

    public SelectRequest(Builder builder) {
        this.transportModeFilter = builder.transportModes.isEmpty() ? null : AllowTransitModeFilter.of(builder.transportModes);
        this.transportModes = builder.transportModes;
        this.agencies = List.copyOf(builder.agencies);
        this.groupOfRoutes = List.copyOf(builder.groupOfRoutes);
        this.routes = builder.routes;
    }

    public boolean matches(TripPattern tripPattern) {
        if (!tripPattern.getContainsMultipleModes() && this.transportModeFilter != null && !this.transportModeFilter.match(tripPattern.getMode(), tripPattern.getNetexSubmode())) {
            return false;
        }
        if (!this.agencies.isEmpty() && !this.agencies.contains(tripPattern.getRoute().getAgency().getId())) {
            return false;
        }
        if (!this.routes.isEmpty() && !this.routes.contains(tripPattern.getRoute().getId())) {
            return false;
        }
        if (!this.groupOfRoutes.isEmpty()) {
            ArrayList<FeedScopedId> ids = new ArrayList<FeedScopedId>();
            for (GroupOfRoutes gor : tripPattern.getRoute().getGroupsOfRoutes()) {
                ids.add(gor.getId());
            }
            if (Collections.disjoint(this.groupOfRoutes, ids)) {
                return false;
            }
        }
        return true;
    }

    public boolean matches(TripTimes tripTimes) {
        Trip trip = tripTimes.getTrip();
        return this.transportModeFilter == null || this.transportModeFilter.match(trip.getMode(), trip.getNetexSubMode());
    }

    public String toString() {
        return ToStringBuilder.of(SelectRequest.class).addObj("transportModes", this.transportModesToString(), null).addCol("agencies", this.agencies, List.of()).addObj("routes", this.routes, List.of()).toString();
    }

    public List<MainAndSubMode> transportModes() {
        return this.transportModes;
    }

    public AllowTransitModeFilter transportModeFilter() {
        return this.transportModeFilter;
    }

    public List<FeedScopedId> agencies() {
        return this.agencies;
    }

    public List<FeedScopedId> routes() {
        return this.routes;
    }

    private String transportModesToString() {
        if (this.transportModes == null) {
            return null;
        }
        if (this.transportModes.stream().allMatch(MainAndSubMode::isMainModeOnly)) {
            int total;
            int size = this.transportModes.size();
            if (size == (total = MainAndSubMode.all().size())) {
                return "ALL-MAIN-MODES";
            }
            if (size + 3 >= total) {
                return "NOT " + MainAndSubMode.toString(MainAndSubMode.notMainModes(this.transportModes));
            }
        }
        return MainAndSubMode.toString(this.transportModes);
    }

    public static class Builder {
        private List<MainAndSubMode> transportModes = new ArrayList<MainAndSubMode>();
        private List<FeedScopedId> agencies = new ArrayList<FeedScopedId>();
        private List<FeedScopedId> groupOfRoutes = new ArrayList<FeedScopedId>();
        private List<FeedScopedId> routes = new ArrayList<FeedScopedId>();

        public Builder withTransportModes(List<MainAndSubMode> transportModes) {
            this.transportModes = transportModes;
            return this;
        }

        public Builder addTransportMode(MainAndSubMode transportMode) {
            this.transportModes.add(transportMode);
            return this;
        }

        public Builder withAgenciesFromString(String s) {
            if (!s.isEmpty()) {
                this.agencies = FeedScopedId.parseListOfIds(s);
            }
            return this;
        }

        public Builder withAgencies(List<FeedScopedId> agencies) {
            this.agencies = agencies;
            return this;
        }

        public Builder withRoutesFromString(String s) {
            if (!s.isEmpty()) {
                this.routes = FeedScopedId.parseListOfIds(s);
            }
            return this;
        }

        public Builder withRoutes(List<FeedScopedId> routes) {
            this.routes = routes;
            return this;
        }

        public Builder withGroupOfRoutes(List<FeedScopedId> groupOfRoutes) {
            this.groupOfRoutes = groupOfRoutes;
            return this;
        }

        public SelectRequest build() {
            return new SelectRequest(this);
        }
    }
}

