/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.routing.api.request.request;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.opentripplanner.model.modes.ExcludeAllTransitFilter;
import org.opentripplanner.routing.api.request.DebugRaptor;
import org.opentripplanner.routing.api.request.request.filter.AllowAllTransitFilter;
import org.opentripplanner.routing.api.request.request.filter.TransitFilter;
import org.opentripplanner.transit.model.framework.FeedScopedId;

public class TransitRequest
implements Cloneable,
Serializable {
    private List<FeedScopedId> bannedTrips = new ArrayList<FeedScopedId>();
    private List<TransitFilter> filters = List.of(AllowAllTransitFilter.of());
    @Deprecated
    private List<FeedScopedId> preferredAgencies = List.of();
    private List<FeedScopedId> unpreferredAgencies = List.of();
    @Deprecated
    private List<FeedScopedId> preferredRoutes = List.of();
    private List<FeedScopedId> unpreferredRoutes = List.of();
    private DebugRaptor raptorDebugging = new DebugRaptor();

    public void setBannedTripsFromString(String ids) {
        if (!ids.isEmpty()) {
            this.bannedTrips = FeedScopedId.parseListOfIds(ids);
        }
    }

    public void setBannedTrips(List<FeedScopedId> bannedTrips) {
        this.bannedTrips = bannedTrips;
    }

    public List<FeedScopedId> bannedTrips() {
        return this.bannedTrips;
    }

    public List<TransitFilter> filters() {
        return this.filters;
    }

    public void setFilters(List<TransitFilter> filters) {
        this.filters = filters;
    }

    @Deprecated
    public void setPreferredAgenciesFromString(String s) {
        if (!s.isEmpty()) {
            this.preferredAgencies = FeedScopedId.parseListOfIds(s);
        }
    }

    @Deprecated
    public void setPreferredAgencies(List<FeedScopedId> preferredAgencies) {
        this.preferredAgencies = preferredAgencies;
    }

    @Deprecated
    public List<FeedScopedId> preferredAgencies() {
        return this.preferredAgencies;
    }

    public void setUnpreferredAgenciesFromString(String s) {
        if (!s.isEmpty()) {
            this.unpreferredAgencies = FeedScopedId.parseListOfIds(s);
        }
    }

    public void setUnpreferredAgencies(List<FeedScopedId> unpreferredAgencies) {
        this.unpreferredAgencies = unpreferredAgencies;
    }

    public List<FeedScopedId> unpreferredAgencies() {
        return this.unpreferredAgencies;
    }

    @Deprecated
    public void setPreferredRoutesFromString(String s) {
        this.preferredRoutes = !s.isEmpty() ? List.copyOf(FeedScopedId.parseListOfIds(s)) : List.of();
    }

    @Deprecated
    public void setPreferredRoutes(List<FeedScopedId> preferredRoutes) {
        this.preferredRoutes = preferredRoutes;
    }

    @Deprecated
    public List<FeedScopedId> preferredRoutes() {
        return this.preferredRoutes;
    }

    public void setUnpreferredRoutesFromString(String s) {
        this.unpreferredRoutes = !s.isEmpty() ? List.copyOf(FeedScopedId.parseListOfIds(s)) : List.of();
    }

    public void setUnpreferredRoutes(List<FeedScopedId> unpreferredRoutes) {
        this.unpreferredRoutes = unpreferredRoutes;
    }

    public List<FeedScopedId> unpreferredRoutes() {
        return this.unpreferredRoutes;
    }

    public void setRaptorDebugging(DebugRaptor raptorDebugging) {
        this.raptorDebugging = raptorDebugging;
    }

    public DebugRaptor raptorDebugging() {
        return this.raptorDebugging;
    }

    public TransitRequest clone() {
        try {
            TransitRequest clone = (TransitRequest)super.clone();
            clone.preferredAgencies = List.copyOf(this.preferredAgencies);
            clone.unpreferredAgencies = List.copyOf(this.unpreferredAgencies);
            clone.preferredRoutes = List.copyOf(this.preferredRoutes);
            clone.unpreferredRoutes = List.copyOf(this.unpreferredRoutes);
            clone.raptorDebugging = new DebugRaptor(this.raptorDebugging);
            clone.setFilters(this.filters);
            return clone;
        }
        catch (CloneNotSupportedException e) {
            throw new RuntimeException(e);
        }
    }

    public boolean enabled() {
        return this.filters.stream().noneMatch(ExcludeAllTransitFilter.class::isInstance);
    }

    public void disable() {
        this.filters = List.of(ExcludeAllTransitFilter.of());
    }
}

