/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.routing.api.request.preference;

import java.io.Serializable;
import java.util.Objects;
import java.util.function.Consumer;
import org.opentripplanner.framework.lang.DoubleUtils;
import org.opentripplanner.framework.tostring.ToStringBuilder;
import org.opentripplanner.routing.api.request.framework.Units;

public final class VehicleRentalPreferences
implements Serializable {
    public static final VehicleRentalPreferences DEFAULT = new VehicleRentalPreferences();
    private final int pickupTime;
    private final int pickupCost;
    private final int dropoffTime;
    private final int dropoffCost;
    private final boolean useAvailabilityInformation;
    private final double arrivingInRentalVehicleAtDestinationCost;

    private VehicleRentalPreferences() {
        this.pickupTime = 60;
        this.pickupCost = 120;
        this.dropoffTime = 30;
        this.dropoffCost = 30;
        this.useAvailabilityInformation = false;
        this.arrivingInRentalVehicleAtDestinationCost = 0.0;
    }

    private VehicleRentalPreferences(Builder builder) {
        this.pickupTime = builder.pickupTime;
        this.pickupCost = builder.pickupCost;
        this.dropoffTime = builder.dropoffTime;
        this.dropoffCost = builder.dropoffCost;
        this.useAvailabilityInformation = builder.useAvailabilityInformation;
        this.arrivingInRentalVehicleAtDestinationCost = DoubleUtils.roundTo1Decimal(builder.arrivingInRentalVehicleAtDestinationCost);
    }

    public static Builder of() {
        return DEFAULT.copyOf();
    }

    public Builder copyOf() {
        return new Builder(this);
    }

    public int pickupTime() {
        return this.pickupTime;
    }

    public int pickupCost() {
        return this.pickupCost;
    }

    public int dropoffTime() {
        return this.dropoffTime;
    }

    public int dropoffCost() {
        return this.dropoffCost;
    }

    public boolean useAvailabilityInformation() {
        return this.useAvailabilityInformation;
    }

    public double arrivingInRentalVehicleAtDestinationCost() {
        return this.arrivingInRentalVehicleAtDestinationCost;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        VehicleRentalPreferences that = (VehicleRentalPreferences)o;
        return this.pickupTime == that.pickupTime && this.pickupCost == that.pickupCost && this.dropoffTime == that.dropoffTime && this.dropoffCost == that.dropoffCost && this.useAvailabilityInformation == that.useAvailabilityInformation && Double.compare(that.arrivingInRentalVehicleAtDestinationCost, this.arrivingInRentalVehicleAtDestinationCost) == 0;
    }

    public int hashCode() {
        return Objects.hash(this.pickupTime, this.pickupCost, this.dropoffTime, this.dropoffCost, this.useAvailabilityInformation, this.arrivingInRentalVehicleAtDestinationCost);
    }

    public String toString() {
        return ToStringBuilder.of(VehicleRentalPreferences.class).addDurationSec("pickupTime", this.pickupTime, VehicleRentalPreferences.DEFAULT.pickupTime).addCost("pickupCost", this.pickupCost, VehicleRentalPreferences.DEFAULT.pickupCost).addDurationSec("dropoffTime", this.dropoffTime, VehicleRentalPreferences.DEFAULT.dropoffTime).addCost("dropoffCost", this.dropoffCost, VehicleRentalPreferences.DEFAULT.dropoffCost).addBoolIfTrue("useAvailabilityInformation", this.useAvailabilityInformation).addNum("arrivingInRentalVehicleAtDestinationCost", (Number)this.arrivingInRentalVehicleAtDestinationCost, VehicleRentalPreferences.DEFAULT.arrivingInRentalVehicleAtDestinationCost).toString();
    }

    public static class Builder {
        private final VehicleRentalPreferences original;
        private int pickupTime;
        private int pickupCost;
        private int dropoffTime;
        private int dropoffCost;
        private boolean useAvailabilityInformation;
        private double arrivingInRentalVehicleAtDestinationCost;

        private Builder(VehicleRentalPreferences original) {
            this.original = original;
            this.pickupTime = Units.duration(original.pickupTime);
            this.pickupCost = Units.cost(original.pickupCost);
            this.dropoffTime = Units.duration(original.dropoffTime);
            this.dropoffCost = Units.cost(original.dropoffCost);
            this.useAvailabilityInformation = original.useAvailabilityInformation;
            this.arrivingInRentalVehicleAtDestinationCost = original.arrivingInRentalVehicleAtDestinationCost;
        }

        public VehicleRentalPreferences original() {
            return this.original;
        }

        public Builder withPickupTime(int pickupTime) {
            this.pickupTime = pickupTime;
            return this;
        }

        public Builder withPickupCost(int pickupCost) {
            this.pickupCost = pickupCost;
            return this;
        }

        public Builder withDropoffTime(int dropoffTime) {
            this.dropoffTime = dropoffTime;
            return this;
        }

        public Builder withDropoffCost(int dropoffCost) {
            this.dropoffCost = dropoffCost;
            return this;
        }

        public Builder withUseAvailabilityInformation(boolean useAvailabilityInformation) {
            this.useAvailabilityInformation = useAvailabilityInformation;
            return this;
        }

        public Builder withArrivingInRentalVehicleAtDestinationCost(double arrivingInRentalVehicleAtDestinationCost) {
            this.arrivingInRentalVehicleAtDestinationCost = arrivingInRentalVehicleAtDestinationCost;
            return this;
        }

        public Builder apply(Consumer<Builder> body) {
            body.accept(this);
            return this;
        }

        public VehicleRentalPreferences build() {
            VehicleRentalPreferences value = new VehicleRentalPreferences(this);
            return this.original.equals(value) ? this.original : value;
        }
    }
}

