/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.routing.api.request.preference;

import java.io.Serializable;
import java.util.Map;
import java.util.Objects;
import java.util.function.Consumer;
import org.opentripplanner.framework.tostring.ToStringBuilder;
import org.opentripplanner.routing.api.request.framework.DoubleAlgorithmFunction;
import org.opentripplanner.routing.api.request.framework.DurationForEnum;
import org.opentripplanner.routing.api.request.framework.RequestFunctions;
import org.opentripplanner.routing.api.request.framework.Units;
import org.opentripplanner.routing.api.request.preference.RaptorPreferences;
import org.opentripplanner.transit.model.basic.TransitMode;

public final class TransitPreferences
implements Serializable {
    public static final TransitPreferences DEFAULT = new TransitPreferences();
    private final DurationForEnum<TransitMode> boardSlack;
    private final DurationForEnum<TransitMode> alightSlack;
    private final Map<TransitMode, Double> reluctanceForMode;
    private final int otherThanPreferredRoutesPenalty;
    private final DoubleAlgorithmFunction unpreferredCost;
    private final boolean ignoreRealtimeUpdates;
    private final boolean includePlannedCancellations;
    private final boolean includeRealtimeCancellations;
    private final RaptorPreferences raptor;

    private TransitPreferences() {
        this.alightSlack = DurationForEnum.of(TransitMode.class).build();
        this.boardSlack = this.alightSlack;
        this.reluctanceForMode = Map.of();
        this.otherThanPreferredRoutesPenalty = 300;
        this.unpreferredCost = RequestFunctions.createLinearFunction(0.0, 1.0);
        this.ignoreRealtimeUpdates = false;
        this.includePlannedCancellations = false;
        this.includeRealtimeCancellations = false;
        this.raptor = RaptorPreferences.DEFAULT;
    }

    private TransitPreferences(Builder builder) {
        this.boardSlack = Objects.requireNonNull(builder.boardSlack);
        this.alightSlack = Objects.requireNonNull(builder.alightSlack);
        this.reluctanceForMode = Map.copyOf(Objects.requireNonNull(builder.reluctanceForMode));
        this.otherThanPreferredRoutesPenalty = Units.cost(builder.otherThanPreferredRoutesPenalty);
        this.unpreferredCost = Objects.requireNonNull(builder.unpreferredCost);
        this.ignoreRealtimeUpdates = builder.ignoreRealtimeUpdates;
        this.includePlannedCancellations = builder.includePlannedCancellations;
        this.includeRealtimeCancellations = builder.includeRealtimeCancellations;
        this.raptor = Objects.requireNonNull(builder.raptor);
    }

    public static Builder of() {
        return DEFAULT.copyOf();
    }

    public Builder copyOf() {
        return new Builder(this);
    }

    public DurationForEnum<TransitMode> boardSlack() {
        return this.boardSlack;
    }

    public DurationForEnum<TransitMode> alightSlack() {
        return this.alightSlack;
    }

    public Map<TransitMode, Double> reluctanceForMode() {
        return this.reluctanceForMode;
    }

    @Deprecated
    public int otherThanPreferredRoutesPenalty() {
        return this.otherThanPreferredRoutesPenalty;
    }

    public DoubleAlgorithmFunction unpreferredCost() {
        return this.unpreferredCost;
    }

    public boolean ignoreRealtimeUpdates() {
        return this.ignoreRealtimeUpdates;
    }

    public boolean includePlannedCancellations() {
        return this.includePlannedCancellations;
    }

    public boolean includeRealtimeCancellations() {
        return this.includeRealtimeCancellations;
    }

    public RaptorPreferences raptor() {
        return this.raptor;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TransitPreferences that = (TransitPreferences)o;
        return this.otherThanPreferredRoutesPenalty == that.otherThanPreferredRoutesPenalty && this.ignoreRealtimeUpdates == that.ignoreRealtimeUpdates && this.includePlannedCancellations == that.includePlannedCancellations && this.includeRealtimeCancellations == that.includeRealtimeCancellations && this.boardSlack.equals(that.boardSlack) && this.alightSlack.equals(that.alightSlack) && this.reluctanceForMode.equals(that.reluctanceForMode) && this.unpreferredCost.equals(that.unpreferredCost) && this.raptor.equals(that.raptor);
    }

    public int hashCode() {
        return Objects.hash(this.boardSlack, this.alightSlack, this.reluctanceForMode, this.otherThanPreferredRoutesPenalty, this.unpreferredCost, this.ignoreRealtimeUpdates, this.includePlannedCancellations, this.includeRealtimeCancellations, this.raptor);
    }

    public String toString() {
        return ToStringBuilder.of(TransitPreferences.class).addObj("boardSlack", this.boardSlack, TransitPreferences.DEFAULT.boardSlack).addObj("alightSlack", this.alightSlack, TransitPreferences.DEFAULT.alightSlack).addObj("reluctanceForMode", this.reluctanceForMode, TransitPreferences.DEFAULT.reluctanceForMode).addNum("otherThanPreferredRoutesPenalty", (Number)this.otherThanPreferredRoutesPenalty, TransitPreferences.DEFAULT.otherThanPreferredRoutesPenalty).addObj("unpreferredCost", this.unpreferredCost, TransitPreferences.DEFAULT.unpreferredCost).addBoolIfTrue("ignoreRealtimeUpdates", this.ignoreRealtimeUpdates != TransitPreferences.DEFAULT.ignoreRealtimeUpdates).addBoolIfTrue("includePlannedCancellations", this.includePlannedCancellations != TransitPreferences.DEFAULT.includePlannedCancellations).addBoolIfTrue("includeRealtimeCancellations", this.includeRealtimeCancellations != TransitPreferences.DEFAULT.includeRealtimeCancellations).addObj("raptor", this.raptor, TransitPreferences.DEFAULT.raptor).toString();
    }

    public static class Builder {
        private final TransitPreferences original;
        private DurationForEnum<TransitMode> boardSlack;
        private DurationForEnum<TransitMode> alightSlack;
        private Map<TransitMode, Double> reluctanceForMode;
        private int otherThanPreferredRoutesPenalty;
        private DoubleAlgorithmFunction unpreferredCost;
        private boolean ignoreRealtimeUpdates;
        private boolean includePlannedCancellations;
        private boolean includeRealtimeCancellations;
        private RaptorPreferences raptor;

        public Builder(TransitPreferences original) {
            this.original = original;
            this.boardSlack = original.boardSlack;
            this.alightSlack = original.alightSlack;
            this.reluctanceForMode = original.reluctanceForMode;
            this.otherThanPreferredRoutesPenalty = original.otherThanPreferredRoutesPenalty;
            this.unpreferredCost = original.unpreferredCost;
            this.ignoreRealtimeUpdates = original.ignoreRealtimeUpdates;
            this.includePlannedCancellations = original.includePlannedCancellations;
            this.includeRealtimeCancellations = original.includeRealtimeCancellations;
            this.raptor = original.raptor;
        }

        public TransitPreferences original() {
            return this.original;
        }

        public Builder withBoardSlack(Consumer<DurationForEnum.Builder<TransitMode>> body) {
            this.boardSlack = this.boardSlack.copyOf().apply(body).build();
            return this;
        }

        public Builder withDefaultBoardSlackSec(int defaultValue) {
            return this.withBoardSlack(it -> it.withDefaultSec(defaultValue));
        }

        public Builder withAlightSlack(Consumer<DurationForEnum.Builder<TransitMode>> body) {
            this.alightSlack = this.alightSlack.copyOf().apply(body).build();
            return this;
        }

        public Builder withDefaultAlightSlackSec(int defaultValue) {
            return this.withAlightSlack(it -> it.withDefaultSec(defaultValue));
        }

        public Builder setReluctanceForMode(Map<TransitMode, Double> reluctanceForMode) {
            this.reluctanceForMode = reluctanceForMode;
            return this;
        }

        @Deprecated
        public Builder setOtherThanPreferredRoutesPenalty(int otherThanPreferredRoutesPenalty) {
            this.otherThanPreferredRoutesPenalty = otherThanPreferredRoutesPenalty;
            return this;
        }

        public Builder setUnpreferredCost(DoubleAlgorithmFunction unpreferredCost) {
            this.unpreferredCost = unpreferredCost;
            return this;
        }

        public Builder setUnpreferredCostString(String constFunction) {
            return this.setUnpreferredCost(RequestFunctions.parse(constFunction));
        }

        public Builder setIgnoreRealtimeUpdates(boolean ignoreRealtimeUpdates) {
            this.ignoreRealtimeUpdates = ignoreRealtimeUpdates;
            return this;
        }

        public Builder setIncludePlannedCancellations(boolean includePlannedCancellations) {
            this.includePlannedCancellations = includePlannedCancellations;
            return this;
        }

        public Builder setIncludeRealtimeCancellations(boolean includeRealtimeCancellations) {
            this.includeRealtimeCancellations = includeRealtimeCancellations;
            return this;
        }

        public Builder withRaptor(Consumer<RaptorPreferences.Builder> body) {
            this.raptor = this.raptor.copyOf().apply(body).build();
            return this;
        }

        public Builder apply(Consumer<Builder> body) {
            body.accept(this);
            return this;
        }

        TransitPreferences build() {
            TransitPreferences value = new TransitPreferences(this);
            return this.original.equals(value) ? this.original : value;
        }
    }
}

