/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.routing.api.request.preference;

import org.opentripplanner.framework.lang.DoubleUtils;

public record TimeSlopeSafetyTriangle(double time, double slope, double safety) {
    private static final double ZERO = 0.0;
    public static final TimeSlopeSafetyTriangle DEFAULT = new TimeSlopeSafetyTriangle(1.0, 1.0, 1.0);

    public TimeSlopeSafetyTriangle(double time, double slope, double safety) {
        safety = TimeSlopeSafetyTriangle.positiveValueOrZero(safety);
        slope = TimeSlopeSafetyTriangle.positiveValueOrZero(slope);
        time = TimeSlopeSafetyTriangle.positiveValueOrZero(time);
        if (TimeSlopeSafetyTriangle.zeroVector(time, slope, safety)) {
            time = 1.0;
            slope = 1.0;
            safety = 1.0;
        }
        double total = safety + slope + time;
        this.time = DoubleUtils.roundTo2Decimals(time /= total);
        this.slope = DoubleUtils.roundTo2Decimals(slope /= total);
        this.safety = DoubleUtils.roundTo2Decimals(1.0 - (this.time + this.slope));
    }

    public static Builder of() {
        return new Builder();
    }

    private static double positiveValueOrZero(double value) {
        return Math.max(0.0, value);
    }

    private static boolean zeroVector(double a, double b, double c) {
        return a == 0.0 && b == 0.0 && c == 0.0;
    }

    public static class Builder {
        private double time = 0.0;
        private double slope = 0.0;
        private double safety = 0.0;

        private Builder() {
        }

        public double time() {
            return this.time;
        }

        public Builder withTime(double time) {
            this.time = time;
            return this;
        }

        public double slope() {
            return this.slope;
        }

        public Builder withSlope(double slope) {
            this.slope = slope;
            return this;
        }

        public double safety() {
            return this.safety;
        }

        public Builder withSafety(double safety) {
            this.safety = safety;
            return this;
        }

        public TimeSlopeSafetyTriangle build() {
            return new TimeSlopeSafetyTriangle(this.time, this.slope, this.safety);
        }

        public TimeSlopeSafetyTriangle buildOrDefault(TimeSlopeSafetyTriangle defaultValue) {
            if (TimeSlopeSafetyTriangle.zeroVector(this.time, this.slope, this.safety)) {
                return defaultValue;
            }
            return new TimeSlopeSafetyTriangle(this.time, this.slope, this.safety);
        }
    }
}

