/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.routing.api.request.preference;

import java.util.Objects;
import java.util.function.Consumer;
import org.opentripplanner.framework.tostring.ToStringBuilder;
import org.opentripplanner.routing.algorithm.filterchain.api.TransitGeneralizedCostFilterParams;
import org.opentripplanner.routing.api.request.framework.DoubleAlgorithmFunction;
import org.opentripplanner.routing.api.request.framework.RequestFunctions;
import org.opentripplanner.routing.api.request.framework.Units;

public final class ItineraryFilterPreferences {
    public static final ItineraryFilterPreferences DEFAULT = new ItineraryFilterPreferences();
    private final boolean accessibilityScore;
    private final double bikeRentalDistanceRatio;
    private final boolean debug;
    private final boolean filterItinerariesWithSameFirstOrLastTrip;
    private final double groupedOtherThanSameLegsMaxCostMultiplier;
    private final double groupSimilarityKeepOne;
    private final double groupSimilarityKeepThree;
    private final double minBikeParkingDistance;
    private final DoubleAlgorithmFunction nonTransitGeneralizedCostLimit;
    private final double parkAndRideDurationRatio;
    private final boolean removeItinerariesWithSameRoutesAndStops;
    private final TransitGeneralizedCostFilterParams transitGeneralizedCostLimit;

    private ItineraryFilterPreferences() {
        this.accessibilityScore = false;
        this.bikeRentalDistanceRatio = 0.0;
        this.debug = false;
        this.filterItinerariesWithSameFirstOrLastTrip = false;
        this.groupedOtherThanSameLegsMaxCostMultiplier = 2.0;
        this.groupSimilarityKeepOne = 0.85;
        this.groupSimilarityKeepThree = 0.68;
        this.minBikeParkingDistance = 0.0;
        this.nonTransitGeneralizedCostLimit = RequestFunctions.createLinearFunction(3600.0, 2.0);
        this.parkAndRideDurationRatio = 0.0;
        this.removeItinerariesWithSameRoutesAndStops = false;
        this.transitGeneralizedCostLimit = new TransitGeneralizedCostFilterParams(RequestFunctions.createLinearFunction(900.0, 1.5), 0.4);
    }

    private ItineraryFilterPreferences(Builder builder) {
        this.accessibilityScore = builder.accessibilityScore;
        this.bikeRentalDistanceRatio = Units.ratio(builder.bikeRentalDistanceRatio);
        this.debug = builder.debug;
        this.filterItinerariesWithSameFirstOrLastTrip = builder.filterItinerariesWithSameFirstOrLastTrip;
        this.groupedOtherThanSameLegsMaxCostMultiplier = Units.reluctance(builder.groupedOtherThanSameLegsMaxCostMultiplier);
        this.groupSimilarityKeepOne = Units.reluctance(builder.groupSimilarityKeepOne);
        this.groupSimilarityKeepThree = Units.reluctance(builder.groupSimilarityKeepThree);
        this.minBikeParkingDistance = builder.minBikeParkingDistance;
        this.nonTransitGeneralizedCostLimit = Objects.requireNonNull(builder.nonTransitGeneralizedCostLimit);
        this.parkAndRideDurationRatio = Units.ratio(builder.parkAndRideDurationRatio);
        this.removeItinerariesWithSameRoutesAndStops = builder.removeItinerariesWithSameRoutesAndStops;
        this.transitGeneralizedCostLimit = Objects.requireNonNull(builder.transitGeneralizedCostLimit);
    }

    public static Builder of() {
        return DEFAULT.copyOf();
    }

    public Builder copyOf() {
        return new Builder(this);
    }

    public boolean useAccessibilityScore() {
        return this.accessibilityScore;
    }

    public double bikeRentalDistanceRatio() {
        return this.bikeRentalDistanceRatio;
    }

    public boolean debug() {
        return this.debug;
    }

    public boolean filterItinerariesWithSameFirstOrLastTrip() {
        return this.filterItinerariesWithSameFirstOrLastTrip;
    }

    public double groupedOtherThanSameLegsMaxCostMultiplier() {
        return this.groupedOtherThanSameLegsMaxCostMultiplier;
    }

    public double groupSimilarityKeepOne() {
        return this.groupSimilarityKeepOne;
    }

    public double groupSimilarityKeepThree() {
        return this.groupSimilarityKeepThree;
    }

    public double minBikeParkingDistance() {
        return this.minBikeParkingDistance;
    }

    public DoubleAlgorithmFunction nonTransitGeneralizedCostLimit() {
        return this.nonTransitGeneralizedCostLimit;
    }

    public double parkAndRideDurationRatio() {
        return this.parkAndRideDurationRatio;
    }

    public boolean removeItinerariesWithSameRoutesAndStops() {
        return this.removeItinerariesWithSameRoutesAndStops;
    }

    public TransitGeneralizedCostFilterParams transitGeneralizedCostLimit() {
        return this.transitGeneralizedCostLimit;
    }

    public String toString() {
        return ToStringBuilder.of(ItineraryFilterPreferences.class).addBoolIfTrue("accessibilityScore", this.accessibilityScore).addNum("bikeRentalDistanceRatio", (Number)this.bikeRentalDistanceRatio, ItineraryFilterPreferences.DEFAULT.bikeRentalDistanceRatio).addBoolIfTrue("debug", this.debug).addBoolIfTrue("filterItinerariesWithSameFirstOrLastTrip", this.filterItinerariesWithSameFirstOrLastTrip).addNum("groupedOtherThanSameLegsMaxCostMultiplier", (Number)this.groupedOtherThanSameLegsMaxCostMultiplier, ItineraryFilterPreferences.DEFAULT.groupedOtherThanSameLegsMaxCostMultiplier).addNum("groupSimilarityKeepOne", (Number)this.groupSimilarityKeepOne, ItineraryFilterPreferences.DEFAULT.groupSimilarityKeepOne).addNum("groupSimilarityKeepThree", (Number)this.groupSimilarityKeepThree, ItineraryFilterPreferences.DEFAULT.groupSimilarityKeepThree).addNum("minBikeParkingDistance", (Number)this.minBikeParkingDistance, ItineraryFilterPreferences.DEFAULT.minBikeParkingDistance).addObj("nonTransitGeneralizedCostLimit", this.nonTransitGeneralizedCostLimit, ItineraryFilterPreferences.DEFAULT.nonTransitGeneralizedCostLimit).addNum("parkAndRideDurationRatio", (Number)this.parkAndRideDurationRatio, ItineraryFilterPreferences.DEFAULT.parkAndRideDurationRatio).addObj("transitGeneralizedCostLimit", this.transitGeneralizedCostLimit, ItineraryFilterPreferences.DEFAULT.transitGeneralizedCostLimit).addBoolIfTrue("removeItinerariesWithSameRoutesAndStops", this.removeItinerariesWithSameRoutesAndStops).toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ItineraryFilterPreferences that = (ItineraryFilterPreferences)o;
        return this.accessibilityScore == that.accessibilityScore && Double.compare(that.bikeRentalDistanceRatio, this.bikeRentalDistanceRatio) == 0 && this.debug == that.debug && this.filterItinerariesWithSameFirstOrLastTrip == that.filterItinerariesWithSameFirstOrLastTrip && Double.compare(that.groupedOtherThanSameLegsMaxCostMultiplier, this.groupedOtherThanSameLegsMaxCostMultiplier) == 0 && Double.compare(that.groupSimilarityKeepOne, this.groupSimilarityKeepOne) == 0 && Double.compare(that.groupSimilarityKeepThree, this.groupSimilarityKeepThree) == 0 && Double.compare(that.minBikeParkingDistance, this.minBikeParkingDistance) == 0 && Double.compare(that.parkAndRideDurationRatio, this.parkAndRideDurationRatio) == 0 && this.removeItinerariesWithSameRoutesAndStops == that.removeItinerariesWithSameRoutesAndStops && Objects.equals(this.nonTransitGeneralizedCostLimit, that.nonTransitGeneralizedCostLimit) && Objects.equals(this.transitGeneralizedCostLimit, that.transitGeneralizedCostLimit);
    }

    public int hashCode() {
        return Objects.hash(this.accessibilityScore, this.bikeRentalDistanceRatio, this.debug, this.filterItinerariesWithSameFirstOrLastTrip, this.groupedOtherThanSameLegsMaxCostMultiplier, this.groupSimilarityKeepOne, this.groupSimilarityKeepThree, this.minBikeParkingDistance, this.nonTransitGeneralizedCostLimit, this.parkAndRideDurationRatio, this.removeItinerariesWithSameRoutesAndStops, this.transitGeneralizedCostLimit);
    }

    public static class Builder {
        private final ItineraryFilterPreferences original;
        private boolean accessibilityScore;
        private double bikeRentalDistanceRatio;
        private boolean debug;
        private boolean filterItinerariesWithSameFirstOrLastTrip;
        private double groupedOtherThanSameLegsMaxCostMultiplier;
        private double groupSimilarityKeepOne;
        private double groupSimilarityKeepThree;
        public double minBikeParkingDistance;
        private DoubleAlgorithmFunction nonTransitGeneralizedCostLimit;
        private double parkAndRideDurationRatio;
        private boolean removeItinerariesWithSameRoutesAndStops;
        private TransitGeneralizedCostFilterParams transitGeneralizedCostLimit;

        public ItineraryFilterPreferences original() {
            return this.original;
        }

        public Builder withAccessibilityScore(boolean accessibilityScore) {
            this.accessibilityScore = accessibilityScore;
            return this;
        }

        public Builder withBikeRentalDistanceRatio(double bikeRentalDistanceRatio) {
            this.bikeRentalDistanceRatio = bikeRentalDistanceRatio;
            return this;
        }

        public Builder withDebug(boolean debug) {
            this.debug = debug;
            return this;
        }

        public Builder withFilterItinerariesWithSameFirstOrLastTrip(boolean filterItinerariesWithSameFirstOrLastTrip) {
            this.filterItinerariesWithSameFirstOrLastTrip = filterItinerariesWithSameFirstOrLastTrip;
            return this;
        }

        public Builder withGroupedOtherThanSameLegsMaxCostMultiplier(double groupedOtherThanSameLegsMaxCostMultiplier) {
            this.groupedOtherThanSameLegsMaxCostMultiplier = groupedOtherThanSameLegsMaxCostMultiplier;
            return this;
        }

        public Builder withGroupSimilarityKeepOne(double groupSimilarityKeepOne) {
            this.groupSimilarityKeepOne = groupSimilarityKeepOne;
            return this;
        }

        public Builder withGroupSimilarityKeepThree(double groupSimilarityKeepThree) {
            this.groupSimilarityKeepThree = groupSimilarityKeepThree;
            return this;
        }

        public Builder withMinBikeParkingDistance(double distance) {
            this.minBikeParkingDistance = distance;
            return this;
        }

        public Builder withNonTransitGeneralizedCostLimit(DoubleAlgorithmFunction nonTransitGeneralizedCostLimit) {
            this.nonTransitGeneralizedCostLimit = nonTransitGeneralizedCostLimit;
            return this;
        }

        public Builder withParkAndRideDurationRatio(double parkAndRideDurationRatio) {
            this.parkAndRideDurationRatio = parkAndRideDurationRatio;
            return this;
        }

        public Builder withRemoveItinerariesWithSameRoutesAndStops(boolean removeItinerariesWithSameRoutesAndStops) {
            this.removeItinerariesWithSameRoutesAndStops = removeItinerariesWithSameRoutesAndStops;
            return this;
        }

        public Builder withTransitGeneralizedCostLimit(TransitGeneralizedCostFilterParams transitGeneralizedCostLimit) {
            this.transitGeneralizedCostLimit = transitGeneralizedCostLimit;
            return this;
        }

        public Builder(ItineraryFilterPreferences original) {
            this.original = original;
            this.accessibilityScore = original.accessibilityScore;
            this.bikeRentalDistanceRatio = original.bikeRentalDistanceRatio;
            this.debug = original.debug;
            this.filterItinerariesWithSameFirstOrLastTrip = original.filterItinerariesWithSameFirstOrLastTrip;
            this.groupedOtherThanSameLegsMaxCostMultiplier = original.groupedOtherThanSameLegsMaxCostMultiplier;
            this.groupSimilarityKeepOne = original.groupSimilarityKeepOne;
            this.groupSimilarityKeepThree = original.groupSimilarityKeepThree;
            this.minBikeParkingDistance = original.minBikeParkingDistance;
            this.nonTransitGeneralizedCostLimit = original.nonTransitGeneralizedCostLimit;
            this.parkAndRideDurationRatio = original.parkAndRideDurationRatio;
            this.removeItinerariesWithSameRoutesAndStops = original.removeItinerariesWithSameRoutesAndStops;
            this.transitGeneralizedCostLimit = original.transitGeneralizedCostLimit;
        }

        public Builder apply(Consumer<Builder> body) {
            body.accept(this);
            return this;
        }

        public ItineraryFilterPreferences build() {
            ItineraryFilterPreferences value = new ItineraryFilterPreferences(this);
            return this.original.equals(value) ? this.original : value;
        }
    }
}

