/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.routing.api.request.framework;

import java.io.Serializable;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.opentripplanner.framework.lang.DoubleUtils;
import org.opentripplanner.framework.lang.OtpNumberFormat;
import org.opentripplanner.routing.api.request.framework.DoubleAlgorithmFunction;

public class RequestFunctions {
    private static final String SEP = "\\s*";
    private static final String NUM = "([\\d.,]+)";
    public static final String PLUS = Pattern.quote("+");
    private static final Pattern LINEAR_FUNCTION_PATTERN = Pattern.compile("([\\d.,]+)\\s*" + PLUS + "\\s*([\\d.,]+)\\s*[Xx]");

    private RequestFunctions() {
    }

    public static DoubleAlgorithmFunction parse(String text) {
        if (text == null || text.isBlank()) {
            return null;
        }
        Matcher m = LINEAR_FUNCTION_PATTERN.matcher(text);
        if (m.find()) {
            return RequestFunctions.createLinearFunction(Double.parseDouble(m.group(1)), Double.parseDouble(m.group(2)));
        }
        throw new IllegalArgumentException("Unable to parse function: '" + text + "'");
    }

    public static DoubleAlgorithmFunction createLinearFunction(double constant, double coefficient) {
        return new LinearFunction(constant, coefficient);
    }

    public static String serialize(Object function) {
        if (function == null) {
            return null;
        }
        if (function instanceof LinearFunction) {
            return ((LinearFunction)function).serialize();
        }
        throw new IllegalArgumentException("Function type is not valid: " + function.getClass());
    }

    private static class LinearFunction
    implements DoubleAlgorithmFunction,
    Serializable {
        private final double a;
        private final double b;

        public LinearFunction(double constant, double coefficient) {
            this.a = DoubleUtils.roundToZeroDecimals(constant);
            this.b = DoubleUtils.roundTo2Decimals(coefficient);
        }

        @Override
        public double calculate(double x) {
            return this.a + this.b * x;
        }

        public String toString() {
            return "f(x) = %s + %s x".formatted(OtpNumberFormat.formatZeroDecimal(this.a), OtpNumberFormat.formatTwoDecimals(this.b));
        }

        String serialize() {
            return this.a + " + " + this.b + " x";
        }
    }
}

