/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.routing.api.request;

import java.io.Serializable;
import java.util.Objects;

public class RoutingTag
implements Serializable {
    private final Category category;
    private final String tag;

    private RoutingTag(Category category, String tag) {
        this.category = category;
        this.tag = tag;
    }

    public static RoutingTag testCaseCategory(String tag) {
        return new RoutingTag(Category.TestCaseCategory, tag);
    }

    public static RoutingTag testCaseSample(String tag) {
        return new RoutingTag(Category.TestCaseSample, tag);
    }

    public Category getCategory() {
        return this.category;
    }

    public String getTag() {
        return this.tag;
    }

    public boolean includeInMicrometerTiming() {
        return this.category.micrometerTiming;
    }

    public String toString() {
        return this.category + ": " + this.tag;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        RoutingTag that = (RoutingTag)o;
        return this.category == that.category && Objects.equals(this.tag, that.tag);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.category, this.tag});
    }

    public static enum Category {
        TestCaseCategory(true),
        TestCaseSample(true);

        public final boolean micrometerTiming;

        private Category(boolean micrometerTiming) {
            this.micrometerTiming = micrometerTiming;
        }
    }
}

