/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.routing.api.request;

import java.io.Serializable;
import java.time.Duration;
import java.time.Instant;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import java.util.function.Consumer;
import org.opentripplanner.model.GenericLocation;
import org.opentripplanner.routing.api.request.RouteRequest;
import org.opentripplanner.routing.api.request.ViaLocation;
import org.opentripplanner.routing.api.request.preference.RoutingPreferences;
import org.opentripplanner.routing.api.request.request.JourneyRequest;

public class RouteViaRequest
implements Serializable {
    private final GenericLocation from;
    private final List<ViaSegment> viaSegments;
    private final GenericLocation to;
    private final Instant dateTime;
    private final Duration searchWindow;
    private final boolean wheelchair;
    private final RoutingPreferences preferences;
    private final Locale locale;
    private final Integer numItineraries;

    private RouteViaRequest(List<ViaLocation> viaLocations, List<JourneyRequest> viaJourneys) {
        if (viaLocations == null || viaLocations.isEmpty()) {
            throw new IllegalArgumentException("viaLocations must not be empty");
        }
        if (viaJourneys == null || viaJourneys.isEmpty() || viaJourneys.size() != viaLocations.size() + 1) {
            throw new IllegalArgumentException("There must be one more JourneyRequest than ViaLocation");
        }
        this.from = null;
        this.viaSegments = new ArrayList<ViaSegment>();
        this.to = null;
        this.dateTime = Instant.now();
        this.searchWindow = null;
        this.wheelchair = false;
        this.preferences = new RoutingPreferences();
        this.locale = null;
        this.numItineraries = null;
        for (int i = 0; i < viaJourneys.size(); ++i) {
            ViaLocation viaLocation = i < viaJourneys.size() - 1 ? viaLocations.get(i) : null;
            this.viaSegments.add(new ViaSegment(viaJourneys.get(i), viaLocation));
        }
    }

    private RouteViaRequest(Builder builder) {
        this.from = Objects.requireNonNull(builder.from);
        this.viaSegments = Objects.requireNonNull(builder.viaSegments);
        this.to = Objects.requireNonNull(builder.to);
        this.dateTime = Objects.requireNonNull(builder.dateTime);
        this.searchWindow = Objects.requireNonNull(builder.searchWindow);
        this.wheelchair = builder.wheelchair;
        this.locale = builder.locale;
        this.preferences = Objects.requireNonNull(builder.preferences);
        this.numItineraries = builder.numItineraries;
    }

    public static Builder of(List<ViaLocation> viaLocations, List<JourneyRequest> viaJourneys) {
        return new Builder(new RouteViaRequest(viaLocations, viaJourneys));
    }

    public Builder copyOf() {
        return new Builder(this);
    }

    public RouteRequest routeRequest() {
        RouteRequest request = new RouteRequest();
        request.setTo(this.to);
        request.setFrom(this.from);
        request.setSearchWindow(this.searchWindow);
        request.setDateTime(this.dateTime);
        request.setWheelchair(this.wheelchair);
        request.setPreferences(this.preferences);
        if (this.numItineraries != null) {
            request.setNumItineraries(this.numItineraries);
        }
        return request;
    }

    public GenericLocation from() {
        return this.from;
    }

    public List<ViaSegment> viaSegment() {
        return this.viaSegments;
    }

    public GenericLocation to() {
        return this.to;
    }

    public Instant dateTime() {
        return this.dateTime;
    }

    public Duration searchWindow() {
        return this.searchWindow;
    }

    public boolean wheelchair() {
        return this.wheelchair;
    }

    public RoutingPreferences preferences() {
        return this.preferences;
    }

    public Locale locale() {
        return this.locale;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof RouteViaRequest)) {
            return false;
        }
        RouteViaRequest other = (RouteViaRequest)o;
        return this.viaSegments.equals(other.viaSegments) && this.from.equals(other.from) && this.to.equals(other.to) && this.dateTime.equals(other.dateTime) && this.searchWindow.equals(other.searchWindow) && this.wheelchair == other.wheelchair && Objects.equals(this.locale, other.locale) && this.preferences.equals(other.preferences) && Objects.equals(this.numItineraries, other.numItineraries);
    }

    public int hashCode() {
        return Objects.hash(this.viaSegments, this.from, this.to, this.dateTime, this.searchWindow, this.wheelchair, this.locale, this.preferences, this.numItineraries);
    }

    public record ViaSegment(JourneyRequest journeyRequest, ViaLocation viaLocation) {
    }

    public static class Builder {
        private final List<ViaSegment> viaSegments;
        private GenericLocation from;
        private GenericLocation to;
        private Instant dateTime;
        private Duration searchWindow;
        private Locale locale;
        private boolean wheelchair;
        private RoutingPreferences preferences;
        private Integer numItineraries;

        public Builder(RouteViaRequest original) {
            this.from = original.from;
            this.to = original.to;
            this.dateTime = original.dateTime;
            this.searchWindow = original.searchWindow;
            this.wheelchair = original.wheelchair;
            this.preferences = original.preferences;
            this.viaSegments = original.viaSegments;
            this.numItineraries = original.numItineraries;
        }

        public RouteViaRequest build() {
            return new RouteViaRequest(this);
        }

        public Builder withFrom(GenericLocation from) {
            this.from = from;
            return this;
        }

        public Builder withTo(GenericLocation to) {
            this.to = to;
            return this;
        }

        public Builder withDateTime(Instant dateTime) {
            this.dateTime = dateTime;
            return this;
        }

        public Builder withSearchWindow(Duration searchWindow) {
            this.searchWindow = searchWindow;
            return this;
        }

        public Builder withLocale(Locale locale) {
            this.locale = locale;
            return this;
        }

        public Builder withWheelchair(boolean wheelchair) {
            this.wheelchair = wheelchair;
            return this;
        }

        public Builder withPreferences(Consumer<RoutingPreferences.Builder> prefs) {
            this.preferences = this.preferences.copyOf().apply(prefs).build();
            return this;
        }

        public Builder withNumItineraries(Integer numItineraries) {
            this.numItineraries = numItineraries;
            return this;
        }
    }
}

