/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.routing.api.request;

import java.io.Serializable;
import java.util.Arrays;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.opentripplanner.framework.tostring.ToStringBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DebugRaptor
implements Serializable {
    private static final Logger LOG = LoggerFactory.getLogger(DebugRaptor.class);
    private static final Pattern FIRST_STOP_PATTERN = Pattern.compile("(\\d+)\\*");
    private static final int FIRST_STOP_INDEX = 0;
    private List<Integer> stops = List.of();
    private List<Integer> path = List.of();
    private int debugPathFromStopIndex = 0;

    public DebugRaptor() {
    }

    public DebugRaptor(DebugRaptor other) {
        this.stops = List.copyOf(other.stops);
        this.path = List.copyOf(other.path);
        this.debugPathFromStopIndex = other.debugPathFromStopIndex;
    }

    public boolean isEnabled() {
        return !this.stops.isEmpty() || !this.path.isEmpty();
    }

    public List<Integer> stops() {
        return this.stops;
    }

    public DebugRaptor withStops(String stops) {
        if (stops == null) {
            return this;
        }
        this.stops = DebugRaptor.split(stops);
        return this;
    }

    public List<Integer> path() {
        return this.path;
    }

    public DebugRaptor withPath(String path) {
        if (path == null) {
            return this;
        }
        this.path = DebugRaptor.split(path);
        this.debugPathFromStopIndex = DebugRaptor.firstStopIndexToDebug(this.path, path);
        return this;
    }

    public int debugPathFromStopIndex() {
        return this.debugPathFromStopIndex;
    }

    public String toString() {
        return ToStringBuilder.of(DebugRaptor.class).addObj("stops", DebugRaptor.toString(this.stops, 0)).addObj("path", DebugRaptor.toString(this.path, this.debugPathFromStopIndex)).toString();
    }

    private static List<Integer> split(String stops) {
        try {
            if (stops == null) {
                return List.of();
            }
            return Arrays.stream(stops.split("[\\s,;_*]+")).map(Integer::parseInt).toList();
        }
        catch (NumberFormatException e) {
            LOG.error(e.getMessage(), (Throwable)e);
            return List.of();
        }
    }

    private static int firstStopIndexToDebug(List<Integer> stops, String text) {
        if (text == null) {
            return 0;
        }
        Matcher m = FIRST_STOP_PATTERN.matcher(text);
        Integer stop = m.find() ? Integer.valueOf(Integer.parseInt(m.group(1))) : null;
        return stop == null ? 0 : stops.indexOf(stop);
    }

    private static String toString(List<Integer> stops, int fromStopIndex) {
        if (stops == null || stops.isEmpty()) {
            return null;
        }
        StringBuilder buf = new StringBuilder();
        for (int i = 0; i < stops.size(); ++i) {
            buf.append(stops.get(i));
            if (i > 0 && i == fromStopIndex) {
                buf.append("*");
            }
            buf.append(", ");
        }
        return buf.substring(0, buf.length() - 2);
    }
}

