/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.routing.algorithm.transferoptimization.services;

import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import org.opentripplanner.raptor.api.model.RaptorTripSchedule;
import org.opentripplanner.raptor.api.path.AccessPathLeg;
import org.opentripplanner.raptor.api.path.PathLeg;
import org.opentripplanner.raptor.api.path.RaptorPath;
import org.opentripplanner.raptor.api.path.RaptorStopNameResolver;
import org.opentripplanner.raptor.api.path.TransferPathLeg;
import org.opentripplanner.raptor.api.path.TransitPathLeg;
import org.opentripplanner.raptor.spi.RaptorCostCalculator;
import org.opentripplanner.raptor.spi.RaptorSlackProvider;
import org.opentripplanner.routing.algorithm.transferoptimization.api.OptimizedPath;
import org.opentripplanner.routing.algorithm.transferoptimization.model.MinCostFilterChain;
import org.opentripplanner.routing.algorithm.transferoptimization.model.OptimizedPathTail;
import org.opentripplanner.routing.algorithm.transferoptimization.model.TransferWaitTimeCostCalculator;
import org.opentripplanner.routing.algorithm.transferoptimization.model.TripToTripTransfer;
import org.opentripplanner.routing.algorithm.transferoptimization.services.TransferGenerator;
import org.opentripplanner.routing.algorithm.transferoptimization.services.TransitPathLegSelector;

public class OptimizePathDomainService<T extends RaptorTripSchedule> {
    private final TransferGenerator<T> transferGenerator;
    private final RaptorCostCalculator<T> costCalculator;
    private final RaptorSlackProvider slackProvider;
    private final MinCostFilterChain<OptimizedPathTail<T>> minCostFilterChain;
    private final RaptorStopNameResolver stopNameTranslator;
    @Nullable
    private final TransferWaitTimeCostCalculator waitTimeCostCalculator;
    @Nullable
    private final int[] stopBoardAlightCosts;
    private final double extraStopBoardAlightCostsFactor;

    public OptimizePathDomainService(TransferGenerator<T> transferGenerator, RaptorCostCalculator<T> costCalculator, RaptorSlackProvider slackProvider, @Nullable TransferWaitTimeCostCalculator waitTimeCostCalculator, int[] stopBoardAlightCosts, double extraStopBoardAlightCostsFactor, MinCostFilterChain<OptimizedPathTail<T>> minCostFilterChain, RaptorStopNameResolver stopNameTranslator) {
        this.transferGenerator = transferGenerator;
        this.costCalculator = costCalculator;
        this.slackProvider = slackProvider;
        this.waitTimeCostCalculator = waitTimeCostCalculator;
        this.stopBoardAlightCosts = stopBoardAlightCosts;
        this.extraStopBoardAlightCostsFactor = extraStopBoardAlightCostsFactor;
        this.minCostFilterChain = minCostFilterChain;
        this.stopNameTranslator = stopNameTranslator;
    }

    public Set<OptimizedPath<T>> findBestTransitPath(RaptorPath<T> originalPath) {
        List transitLegs = originalPath.transitLegs().collect(Collectors.toList());
        List<List<TripToTripTransfer<T>>> possibleTransfers = this.sortTransfersOnArrivalTimeInDecOrder(this.transferGenerator.findAllPossibleTransfers(transitLegs));
        Set<OptimizedPathTail<T>> tails = this.findBestTransferOption(originalPath, transitLegs, possibleTransfers);
        return tails.stream().map(OptimizedPathTail::build).collect(Collectors.toSet());
    }

    private static <T> T last(List<T> list) {
        return list.get(list.size() - 1);
    }

    private Set<OptimizedPathTail<T>> findBestTransferOption(RaptorPath<T> originalPath, List<TransitPathLeg<T>> originalTransitLegs, List<List<TripToTripTransfer<T>>> possibleTransfers) {
        int iterationDepartureTime = originalPath.rangeRaptorIterationDepartureTime();
        Set<OptimizedPathTail<T>> tails = Set.of(new OptimizedPathTail<T>(this.slackProvider, this.costCalculator, iterationDepartureTime, this.waitTimeCostCalculator, this.stopBoardAlightCosts, this.extraStopBoardAlightCostsFactor, this.stopNameTranslator).addTransitTail(OptimizePathDomainService.last(originalTransitLegs)));
        int accessArrivalTime = originalPath.accessLeg().toTime();
        for (int i = possibleTransfers.size() - 1; i >= 0; --i) {
            List<TripToTripTransfer<T>> transfers = possibleTransfers.get(i);
            TransitPathLeg<T> originalFromTransitLeg = originalTransitLegs.get(i);
            int earliestDepartureTimeFromLeg = i == 0 ? accessArrivalTime : OptimizePathDomainService.last(possibleTransfers.get(i - 1)).to().time();
            TransitPathLegSelector<T> tailSelector = new TransitPathLegSelector<T>(this.minCostFilterChain, tails);
            tails = new HashSet<OptimizedPathTail<T>>();
            for (TripToTripTransfer<T> tx : transfers) {
                if (tx.from().time() <= earliestDepartureTimeFromLeg) continue;
                Set<OptimizedPathTail<T>> candidateTails = tailSelector.next(tx.to().time());
                for (OptimizedPathTail<T> tail : candidateTails) {
                    if (tail == null) continue;
                    tails.add(this.createNewTransitLegTail(originalFromTransitLeg, tx, tail));
                }
            }
        }
        tails = new TransitPathLegSelector<T>(this.minCostFilterChain, tails).next(originalPath.accessLeg().toTime());
        this.insertAccess(originalPath, tails);
        return tails;
    }

    private void insertAccess(RaptorPath<T> originalPath, Set<OptimizedPathTail<T>> tails) {
        TransitPathLeg<T> nextTransitLeg;
        AccessPathLeg<T> accessLeg = originalPath.accessLeg();
        PathLeg<T> nextLeg = accessLeg.nextLeg();
        TransferPathLeg<T> nextTransferLeg = null;
        if (nextLeg.isTransferLeg()) {
            nextTransferLeg = nextLeg.asTransferLeg();
            nextTransitLeg = nextTransferLeg.nextLeg().asTransitLeg();
        } else {
            nextTransitLeg = accessLeg.nextLeg().asTransitLeg();
        }
        int boardPos = nextTransitLeg.getFromStopPosition();
        for (OptimizedPathTail<T> path : tails) {
            path.head().changeBoardingPosition(boardPos);
            if (nextTransferLeg != null) {
                path.transfer(nextTransferLeg.transfer(), nextTransferLeg.toStop());
            }
            path.access(accessLeg.access());
        }
    }

    private OptimizedPathTail<T> createNewTransitLegTail(TransitPathLeg<T> originalLeg, TripToTripTransfer<T> tx, OptimizedPathTail<T> tail) {
        return tail.mutate().addTransitAndTransferLeg(originalLeg, tx);
    }

    private List<List<TripToTripTransfer<T>>> sortTransfersOnArrivalTimeInDecOrder(List<List<TripToTripTransfer<T>>> transfers) {
        return transfers.stream().map(it -> it.stream().sorted(Comparator.comparingInt(l -> -l.to().time())).collect(Collectors.toList())).collect(Collectors.toList());
    }
}

