/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.routing.algorithm.transferoptimization.model;

import javax.annotation.Nullable;
import org.opentripplanner.framework.tostring.ValueObjectToStringBuilder;
import org.opentripplanner.model.transfer.TransferConstraint;
import org.opentripplanner.raptor.api.model.RaptorConstrainedTransfer;
import org.opentripplanner.raptor.api.model.RaptorTransfer;
import org.opentripplanner.raptor.api.model.RaptorTripSchedule;
import org.opentripplanner.raptor.api.path.PathLeg;
import org.opentripplanner.raptor.api.path.RaptorStopNameResolver;
import org.opentripplanner.raptor.api.path.TransitPathLeg;
import org.opentripplanner.raptor.path.PathBuilder;
import org.opentripplanner.raptor.path.PathBuilderLeg;
import org.opentripplanner.raptor.spi.BoardAndAlightTime;
import org.opentripplanner.raptor.spi.RaptorCostCalculator;
import org.opentripplanner.raptor.spi.RaptorSlackProvider;
import org.opentripplanner.routing.algorithm.transferoptimization.api.OptimizedPath;
import org.opentripplanner.routing.algorithm.transferoptimization.api.TransferOptimized;
import org.opentripplanner.routing.algorithm.transferoptimization.model.StopPriorityCostCalculator;
import org.opentripplanner.routing.algorithm.transferoptimization.model.TransferWaitTimeCostCalculator;
import org.opentripplanner.routing.algorithm.transferoptimization.model.TripToTripTransfer;

public class OptimizedPathTail<T extends RaptorTripSchedule>
extends PathBuilder<T>
implements TransferOptimized {
    @Nullable
    private final TransferWaitTimeCostCalculator waitTimeCostCalculator;
    private final StopPriorityCostCalculator stopPriorityCostCalculator;
    private int transferPriorityCost = 0;
    private int waitTimeOptimizedCost = 0;
    private int generalizedCost = 0;

    public OptimizedPathTail(RaptorSlackProvider slackProvider, RaptorCostCalculator<T> costCalculator, int iterationDepartureTime, TransferWaitTimeCostCalculator waitTimeCostCalculator, int[] stopBoardAlightCosts, double extraStopBoardAlightCostsFactor, RaptorStopNameResolver stopNameResolver) {
        super(slackProvider, iterationDepartureTime, costCalculator, stopNameResolver, null);
        this.waitTimeCostCalculator = waitTimeCostCalculator;
        this.stopPriorityCostCalculator = stopBoardAlightCosts != null && extraStopBoardAlightCostsFactor > 0.01 ? new StopPriorityCostCalculator(extraStopBoardAlightCostsFactor, stopBoardAlightCosts) : null;
    }

    private OptimizedPathTail(OptimizedPathTail<T> other) {
        super(other);
        this.waitTimeCostCalculator = other.waitTimeCostCalculator;
        this.waitTimeOptimizedCost = other.waitTimeOptimizedCost;
        this.transferPriorityCost = other.transferPriorityCost;
        this.stopPriorityCostCalculator = other.stopPriorityCostCalculator;
        this.generalizedCost = other.generalizedCost;
    }

    public OptimizedPathTail<T> mutate() {
        return new OptimizedPathTail<T>(this);
    }

    public OptimizedPathTail<T> addTransitTail(TransitPathLeg<T> leg) {
        PathLeg<T> next = leg.nextLeg();
        RaptorTransfer transfer = null;
        if (next.isTransferLeg()) {
            transfer = next.asTransferLeg().transfer();
            next = next.nextLeg();
        }
        if (next.isEgressLeg()) {
            this.egress(next.asEgressLeg().egress());
            if (transfer != null) {
                this.transfer(transfer, transfer.stop());
            }
        } else {
            throw new IllegalStateException("We expect an egress leg at the end of the RAPTOR path.");
        }
        BoardAndAlightTime times = new BoardAndAlightTime((RaptorTripSchedule)leg.trip(), leg.getFromStopPosition(), leg.getToStopPosition());
        this.transit(leg.trip(), times);
        return this;
    }

    public OptimizedPathTail<T> addTransitAndTransferLeg(TransitPathLeg<T> originalLeg, TripToTripTransfer<T> tx) {
        this.head().changeBoardingPosition(tx.to().stopPosition());
        if (!tx.sameStop()) {
            this.transfer(tx.getPathTransfer(), tx.to().stop());
        }
        int boardStopPos = 0;
        T trip = originalLeg.trip();
        BoardAndAlightTime times = new BoardAndAlightTime((RaptorTripSchedule)trip, boardStopPos, tx.from().stopPosition());
        this.transit(trip, times, tx.constrainedTransfer());
        return this;
    }

    @Override
    public OptimizedPath<T> build() {
        return new OptimizedPath(this.createPathLegs(this.costCalculator(), this.slackProvider()), this.iterationDepartureTime, this.generalizedCost, this.transferPriorityCost, this.waitTimeOptimizedCost, this.breakTieCost());
    }

    @Override
    public String toString() {
        return ValueObjectToStringBuilder.of().addObj(super.toString()).addText(" [").addCostCenti(this.generalizedCost()).addCostCenti(this.transferPriorityCost, "pri").addCostCenti(this.generalizedCostWaitTimeOptimized(), "wtc").addText("]").toString();
    }

    @Override
    protected void add(PathBuilderLeg<T> newLeg) {
        this.addHead(newLeg);
        newLeg.timeShiftThisAndNextLeg(this.slackProvider(), this.iterationDepartureTime);
        this.addTransferPriorityCost(newLeg);
        this.addOptimizedWaitTimeCost(newLeg);
        this.updateGeneralizedCost();
    }

    @Override
    protected void updateAggregatedFields() {
    }

    public int generalizedCost() {
        return this.generalizedCost;
    }

    public int latestPossibleBoardingTime() {
        return this.head().toTime();
    }

    @Override
    public int transferPriorityCost() {
        return this.transferPriorityCost;
    }

    @Override
    public int generalizedCostWaitTimeOptimized() {
        return this.generalizedCost + this.waitTimeOptimizedCost;
    }

    @Override
    public int breakTieCost() {
        return this.legsAsStream().filter(PathBuilderLeg::isTransit).mapToInt(PathBuilderLeg::toTime).sum();
    }

    private void updateGeneralizedCost() {
        if (this.skipCostCalc()) {
            return;
        }
        this.generalizedCost = this.legsAsStream().mapToInt(it -> it.generalizedCost(this.costCalculator(), this.slackProvider())).sum();
    }

    private void addTransferPriorityCost(PathBuilderLeg<T> pathLeg) {
        boolean transferExist = pathLeg.isTransit() && pathLeg.nextTransitLeg() != null;
        this.transferPriorityCost += OptimizedPath.priorityCost(transferExist, pathLeg::constrainedTransferAfterLeg);
    }

    private void addOptimizedWaitTimeCost(PathBuilderLeg<?> pathLeg) {
        TransferConstraint c;
        if (this.waitTimeCostCalculator == null) {
            return;
        }
        this.waitTimeOptimizedCost += this.extraStopPriorityCost(pathLeg);
        if (!pathLeg.isTransit() || pathLeg.nextTransitLeg() == null) {
            return;
        }
        int waitTime = pathLeg.waitTimeBeforeNextTransitIncludingSlack();
        if (waitTime < 0) {
            return;
        }
        RaptorConstrainedTransfer tx = pathLeg.constrainedTransferAfterLeg();
        if (tx != null && (c = (TransferConstraint)tx.getTransferConstraint()) != null && c.isFacilitated()) {
            if (c.isStaySeated()) {
                this.waitTimeOptimizedCost += this.waitTimeCostCalculator.calculateStaySeatedTransferCost();
            } else if (c.isGuaranteed()) {
                this.waitTimeOptimizedCost += this.waitTimeCostCalculator.calculateGuaranteedTransferCost();
            }
            return;
        }
        this.waitTimeOptimizedCost += this.waitTimeCostCalculator.calculateOptimizedWaitCost(waitTime);
    }

    private int extraStopPriorityCost(PathBuilderLeg<?> leg) {
        if (this.stopPriorityCostCalculator == null) {
            return 0;
        }
        int extraCost = 0;
        if (leg.next() != null && leg.next().isTransit()) {
            extraCost += this.stopPriorityCostCalculator.extraStopPriorityCost(leg.toStop());
        }
        if (leg.isTransit()) {
            extraCost += this.stopPriorityCostCalculator.extraStopPriorityCost(leg.toStop());
        }
        return extraCost;
    }
}

