/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.routing.algorithm.transferoptimization.api;

import java.util.function.Supplier;
import org.opentripplanner.model.transfer.TransferConstraint;
import org.opentripplanner.raptor.api.model.RaptorConstrainedTransfer;
import org.opentripplanner.raptor.api.model.RaptorTripSchedule;
import org.opentripplanner.raptor.api.path.AccessPathLeg;
import org.opentripplanner.raptor.api.path.PathLeg;
import org.opentripplanner.raptor.api.path.PathStringBuilder;
import org.opentripplanner.raptor.api.path.RaptorPath;
import org.opentripplanner.raptor.api.path.RaptorStopNameResolver;
import org.opentripplanner.raptor.path.Path;
import org.opentripplanner.routing.algorithm.transferoptimization.api.TransferOptimized;

public class OptimizedPath<T extends RaptorTripSchedule>
extends Path<T>
implements TransferOptimized {
    private final int transferPriorityCost;
    private final int waitTimeOptimizedCost;
    private final int breakTieCost;

    public OptimizedPath(RaptorPath<T> originalPath) {
        this(originalPath.accessLeg(), originalPath.rangeRaptorIterationDepartureTime(), originalPath.c1(), OptimizedPath.priorityCost(originalPath), 0, 0);
    }

    public OptimizedPath(AccessPathLeg<T> accessPathLeg, int iterationStartTime, int generalizedCost, int transferPriorityCost, int waitTimeOptimizedCost, int breakTieCost) {
        super(iterationStartTime, accessPathLeg, generalizedCost);
        this.transferPriorityCost = transferPriorityCost;
        this.waitTimeOptimizedCost = waitTimeOptimizedCost;
        this.breakTieCost = breakTieCost;
    }

    public static int priorityCost(boolean transferExist, Supplier<RaptorConstrainedTransfer> txGet) {
        if (transferExist) {
            RaptorConstrainedTransfer tx = txGet.get();
            TransferConstraint c = tx == null ? null : (TransferConstraint)tx.getTransferConstraint();
            return TransferConstraint.cost(c);
        }
        return 0;
    }

    @Override
    public int transferPriorityCost() {
        return this.transferPriorityCost;
    }

    @Override
    public int generalizedCostWaitTimeOptimized() {
        return this.c1() + this.waitTimeOptimizedCost;
    }

    @Override
    public int breakTieCost() {
        return this.breakTieCost;
    }

    @Override
    public String toStringDetailed(RaptorStopNameResolver stopNameResolver) {
        return this.buildString(true, stopNameResolver, this::appendSummary);
    }

    @Override
    public String toString(RaptorStopNameResolver stopNameResolver) {
        return this.buildString(false, stopNameResolver, this::appendSummary);
    }

    @Override
    public String toString() {
        return this.toString(null);
    }

    private static int priorityCost(RaptorPath<?> path) {
        return path.legStream().mapToInt(OptimizedPath::priorityCost).sum();
    }

    private static int priorityCost(PathLeg<?> leg) {
        return OptimizedPath.priorityCost(leg.isTransitLeg() && leg.nextTransitLeg() != null, () -> leg.asTransitLeg().getConstrainedTransferAfterLeg());
    }

    private void appendSummary(PathStringBuilder buf) {
        buf.costCentiSec(this.transferPriorityCost, 0, "pri");
        buf.costCentiSec(this.generalizedCostWaitTimeOptimized(), this.c1(), "wtc");
    }
}

