/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.routing.algorithm.raptoradapter.transit.request;

import java.time.LocalDate;
import java.util.function.IntUnaryOperator;
import org.opentripplanner.framework.tostring.ToStringBuilder;
import org.opentripplanner.raptor.api.model.RaptorTripPattern;
import org.opentripplanner.raptor.spi.IntIterator;
import org.opentripplanner.routing.algorithm.raptoradapter.transit.TripPatternForDate;
import org.opentripplanner.routing.algorithm.raptoradapter.transit.TripSchedule;
import org.opentripplanner.routing.algorithm.raptoradapter.transit.request.TripPatternForDates;
import org.opentripplanner.transit.model.basic.Accessibility;
import org.opentripplanner.transit.model.network.TripPattern;
import org.opentripplanner.transit.model.timetable.TripTimes;

public final class TripScheduleWithOffset
implements TripSchedule {
    private final TripPatternForDates pattern;
    private final int sortIndex;
    private final int tripIndexForDates;
    private final IntUnaryOperator arrivalTimes;
    private final IntUnaryOperator departureTimes;
    private TripTimes tripTimes = null;
    private LocalDate serviceDate = null;
    private int secondsOffset;

    TripScheduleWithOffset(TripPatternForDates pattern, int tripIndexForDates) {
        this.tripIndexForDates = tripIndexForDates;
        this.pattern = pattern;
        this.arrivalTimes = pattern.getArrivalTimesForTrip(tripIndexForDates);
        this.departureTimes = pattern.getDepartureTimesForTrip(tripIndexForDates);
        this.sortIndex = this.arrivalTimes.applyAsInt(0);
    }

    @Override
    public int tripSortIndex() {
        return this.sortIndex;
    }

    @Override
    public int arrival(int stopPosInPattern) {
        return this.arrivalTimes.applyAsInt(stopPosInPattern);
    }

    @Override
    public int departure(int stopPosInPattern) {
        return this.departureTimes.applyAsInt(stopPosInPattern);
    }

    @Override
    public RaptorTripPattern pattern() {
        return this.pattern;
    }

    @Override
    public int transitReluctanceFactorIndex() {
        return this.pattern.transitReluctanceFactorIndex();
    }

    @Override
    public Accessibility wheelchairBoarding() {
        return this.pattern.wheelchairBoardingForTrip(this.tripIndexForDates);
    }

    @Override
    public TripTimes getOriginalTripTimes() {
        if (this.tripTimes == null) {
            this.findTripTimes();
        }
        return this.tripTimes;
    }

    @Override
    public TripPattern getOriginalTripPattern() {
        return this.pattern.getTripPattern().getPattern();
    }

    @Override
    public LocalDate getServiceDate() {
        if (this.tripTimes == null) {
            this.findTripTimes();
        }
        return this.serviceDate;
    }

    public int getSecondsOffset() {
        if (this.tripTimes == null) {
            this.findTripTimes();
        }
        return this.secondsOffset;
    }

    public String toString() {
        return ToStringBuilder.of(TripScheduleWithOffset.class).addObj("trip", this.pattern.debugInfo()).addServiceTime("depart", this.secondsOffset + this.getOriginalTripTimes().getDepartureTime(0)).toString();
    }

    private void findTripTimes() {
        int index = this.tripIndexForDates;
        IntIterator indexIterator = this.pattern.tripPatternForDatesIndexIterator(true);
        while (indexIterator.hasNext()) {
            int i = indexIterator.next();
            TripPatternForDate tripPatternForDate = this.pattern.tripPatternForDate(i);
            int numSchedules = tripPatternForDate.numberOfTripSchedules();
            if (index < numSchedules) {
                this.tripTimes = tripPatternForDate.getTripTimes(index);
                this.serviceDate = tripPatternForDate.getLocalDate();
                this.secondsOffset = this.pattern.tripPatternForDateOffsets(i);
                return;
            }
            index -= numSchedules;
        }
        throw new IndexOutOfBoundsException("Index out of bound: " + index);
    }
}

