/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.routing.algorithm.raptoradapter.transit.request;

import java.util.function.IntUnaryOperator;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.opentripplanner.framework.tostring.ToStringBuilder;
import org.opentripplanner.raptor.api.model.RaptorTransferConstraint;
import org.opentripplanner.raptor.api.model.RaptorTripSchedule;
import org.opentripplanner.raptor.spi.RaptorBoardOrAlightEvent;
import org.opentripplanner.raptor.spi.RaptorTripScheduleSearch;
import org.opentripplanner.routing.algorithm.raptoradapter.transit.request.TripSearchTimetable;

public final class TripScheduleAlightSearch<T extends RaptorTripSchedule>
implements RaptorTripScheduleSearch<T>,
RaptorBoardOrAlightEvent<T> {
    private final TripSearchTimetable<T> timetable;
    private final int nTrips;
    private final int binarySearchThreshold;
    private int latestAlightTime;
    private int stopPositionInPattern;
    private IntUnaryOperator arrivalTimes;
    private T candidateTrip;
    private int candidateTripIndex = -2111000000;

    TripScheduleAlightSearch(TripSearchTimetable<T> timetable, int binarySearchThreshold) {
        this.timetable = timetable;
        this.nTrips = timetable.numberOfTripSchedules();
        this.binarySearchThreshold = binarySearchThreshold;
    }

    @Override
    public T trip() {
        return this.candidateTrip;
    }

    @Override
    public int tripIndex() {
        return this.candidateTripIndex;
    }

    @Override
    public int time() {
        return this.candidateTrip.arrival(this.stopPositionInPattern);
    }

    @Override
    public int earliestBoardTime() {
        return this.latestAlightTime;
    }

    @Override
    public int stopPositionInPattern() {
        return this.stopPositionInPattern;
    }

    @Override
    @Nonnull
    public RaptorTransferConstraint transferConstraint() {
        return RaptorTransferConstraint.REGULAR_TRANSFER;
    }

    @Override
    public boolean empty() {
        return this.candidateTripIndex == -2111000000;
    }

    @Override
    public RaptorBoardOrAlightEvent<T> search(int latestAlightTime, int stopPositionInPattern, int tripIndexLowerBound) {
        this.latestAlightTime = latestAlightTime;
        this.stopPositionInPattern = stopPositionInPattern;
        this.arrivalTimes = this.timetable.getArrivalTimes(stopPositionInPattern);
        this.candidateTrip = null;
        this.candidateTripIndex = -2111000000;
        if (tripIndexLowerBound == -1) {
            if (this.nTrips > this.binarySearchThreshold) {
                return this.findFirstBoardingOptimizedForLargeSetOfTrips();
            }
            return this.findBoardingSearchForwardInTime(0);
        }
        return this.findBoardingSearchForwardInTime(tripIndexLowerBound + 1);
    }

    public String toString() {
        return ToStringBuilder.of(TripScheduleAlightSearch.class).addObj("nTrips", this.nTrips).addObj("latestAlightTime", this.latestAlightTime).addObj("stopPos", this.stopPositionInPattern).addObj("tripIndex", this.candidateTripIndex).addObj("trip", this.candidateTrip).toString();
    }

    private RaptorBoardOrAlightEvent<T> findFirstBoardingOptimizedForLargeSetOfTrips() {
        int indexBestGuess = this.binarySearchForTripIndex();
        RaptorBoardOrAlightEvent<T> result = this.findBoardingSearchForwardInTime(indexBestGuess);
        if (!result.empty()) {
            return this;
        }
        return this.findBoardingSearchBackwardsInTime(indexBestGuess);
    }

    @Nullable
    private RaptorBoardOrAlightEvent<T> findBoardingSearchForwardInTime(int tripIndexLowerBound) {
        int i = tripIndexLowerBound;
        while (i < this.nTrips && this.arrivalTimes.applyAsInt(i) <= this.latestAlightTime) {
            this.candidateTripIndex = i++;
        }
        if (this.candidateTripIndex != -2111000000) {
            this.candidateTrip = this.timetable.getTripSchedule(this.candidateTripIndex);
        }
        return this;
    }

    private RaptorBoardOrAlightEvent<T> findBoardingSearchBackwardsInTime(int tripIndexUpperBound) {
        for (int i = tripIndexUpperBound - 1; i >= 0; --i) {
            if (this.arrivalTimes.applyAsInt(i) > this.latestAlightTime) continue;
            this.candidateTrip = this.timetable.getTripSchedule(i);
            this.candidateTripIndex = i;
            return this;
        }
        return this;
    }

    private int binarySearchForTripIndex() {
        int lower = 0;
        int upper = this.nTrips;
        while (upper - lower > this.binarySearchThreshold) {
            int m = (lower + upper) / 2;
            if (this.arrivalTimes.applyAsInt(m) <= this.latestAlightTime) {
                lower = m;
                continue;
            }
            upper = m;
        }
        return lower;
    }
}

