/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.routing.algorithm.raptoradapter.transit.request;

import java.time.ZonedDateTime;
import java.util.BitSet;
import java.util.Iterator;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.opentripplanner.framework.application.OTPFeature;
import org.opentripplanner.framework.time.ServiceDateUtils;
import org.opentripplanner.model.transfer.TransferService;
import org.opentripplanner.raptor.api.model.RaptorConstrainedTransfer;
import org.opentripplanner.raptor.api.model.RaptorTransfer;
import org.opentripplanner.raptor.api.path.RaptorStopNameResolver;
import org.opentripplanner.raptor.spi.IntIterator;
import org.opentripplanner.raptor.spi.RaptorConstrainedBoardingSearch;
import org.opentripplanner.raptor.spi.RaptorCostCalculator;
import org.opentripplanner.raptor.spi.RaptorPathConstrainedTransferSearch;
import org.opentripplanner.raptor.spi.RaptorRoute;
import org.opentripplanner.raptor.spi.RaptorSlackProvider;
import org.opentripplanner.raptor.spi.RaptorTransitDataProvider;
import org.opentripplanner.raptor.util.BitSetIterator;
import org.opentripplanner.routing.algorithm.raptoradapter.transit.RaptorTransferIndex;
import org.opentripplanner.routing.algorithm.raptoradapter.transit.SlackProvider;
import org.opentripplanner.routing.algorithm.raptoradapter.transit.TransitLayer;
import org.opentripplanner.routing.algorithm.raptoradapter.transit.TripSchedule;
import org.opentripplanner.routing.algorithm.raptoradapter.transit.constrainedtransfer.ConstrainedBoardingSearch;
import org.opentripplanner.routing.algorithm.raptoradapter.transit.constrainedtransfer.ConstrainedTransfersForPatterns;
import org.opentripplanner.routing.algorithm.raptoradapter.transit.constrainedtransfer.TransferForPatternByStopPos;
import org.opentripplanner.routing.algorithm.raptoradapter.transit.cost.CostCalculatorFactory;
import org.opentripplanner.routing.algorithm.raptoradapter.transit.cost.GeneralizedCostParameters;
import org.opentripplanner.routing.algorithm.raptoradapter.transit.mappers.GeneralizedCostParametersMapper;
import org.opentripplanner.routing.algorithm.raptoradapter.transit.request.RaptorRoutingRequestTransitDataCreator;
import org.opentripplanner.routing.algorithm.raptoradapter.transit.request.TransitDataProviderFilter;
import org.opentripplanner.routing.algorithm.raptoradapter.transit.request.TripPatternForDates;
import org.opentripplanner.routing.api.request.RouteRequest;
import org.opentripplanner.transit.model.network.RoutingTripPattern;
import org.opentripplanner.transit.model.site.StopLocation;

public class RaptorRoutingRequestTransitData
implements RaptorTransitDataProvider<TripSchedule> {
    private final TransitLayer transitLayer;
    private final TransferService transferService;
    private final List<int[]> activeTripPatternsPerStop;
    private final List<TripPatternForDates> patternIndex;
    private final RaptorTransferIndex transferIndex;
    private final ConstrainedTransfersForPatterns constrainedTransfers;
    private final ZonedDateTime transitSearchTimeZero;
    private final RaptorCostCalculator<TripSchedule> generalizedCostCalculator;
    private final RaptorSlackProvider slackProvider;
    private final int validTransitDataStartTime;
    private final int validTransitDataEndTime;

    public RaptorRoutingRequestTransitData(TransitLayer transitLayer, ZonedDateTime transitSearchTimeZero, int additionalPastSearchDays, int additionalFutureSearchDays, TransitDataProviderFilter filter, RouteRequest request) {
        this.transferService = transitLayer.getTransferService();
        this.transitLayer = transitLayer;
        this.transitSearchTimeZero = transitSearchTimeZero;
        RaptorRoutingRequestTransitDataCreator transitDataCreator = new RaptorRoutingRequestTransitDataCreator(transitLayer, transitSearchTimeZero);
        List<TripPatternForDates> tripPatterns = transitDataCreator.createTripPatterns(additionalPastSearchDays, additionalFutureSearchDays, filter);
        this.patternIndex = transitDataCreator.createPatternIndex(tripPatterns);
        this.activeTripPatternsPerStop = transitDataCreator.createTripPatternsPerStop(tripPatterns);
        this.transferIndex = transitLayer.getRaptorTransfersForRequest(request);
        this.constrainedTransfers = transitLayer.getConstrainedTransfers();
        GeneralizedCostParameters mcCostParams = GeneralizedCostParametersMapper.map(request, this.patternIndex);
        this.generalizedCostCalculator = CostCalculatorFactory.createCostCalculator(mcCostParams, transitLayer.getStopBoardAlightCosts());
        this.slackProvider = new SlackProvider(request.preferences().transfer().slack(), request.preferences().transit().boardSlack(), request.preferences().transit().alightSlack());
        this.validTransitDataStartTime = ServiceDateUtils.secondsSinceStartOfTime(this.transitSearchTimeZero, this.transitSearchTimeZero.minusDays(additionalPastSearchDays).toInstant());
        this.validTransitDataEndTime = ServiceDateUtils.secondsSinceStartOfTime(this.transitSearchTimeZero, this.transitSearchTimeZero.plusDays(additionalFutureSearchDays + 1).toInstant());
    }

    @Override
    public Iterator<RaptorTransfer> getTransfersFromStop(int stopIndex) {
        return this.transferIndex.getForwardTransfers(stopIndex).iterator();
    }

    @Override
    public Iterator<? extends RaptorTransfer> getTransfersToStop(int stopIndex) {
        return this.transferIndex.getReversedTransfers(stopIndex).iterator();
    }

    @Override
    public IntIterator routeIndexIterator(IntIterator stops) {
        BitSet activeTripPatternsForGivenStops = new BitSet(RoutingTripPattern.indexCounter());
        while (stops.hasNext()) {
            int[] patterns;
            for (int i : patterns = this.activeTripPatternsPerStop.get(stops.next())) {
                activeTripPatternsForGivenStops.set(i);
            }
        }
        return new BitSetIterator(activeTripPatternsForGivenStops);
    }

    @Override
    public RaptorRoute<TripSchedule> getRouteForIndex(int routeIndex) {
        return this.patternIndex.get(routeIndex);
    }

    @Override
    public int numberOfStops() {
        return this.transitLayer.getStopCount();
    }

    @Override
    public RaptorCostCalculator<TripSchedule> multiCriteriaCostCalculator() {
        return this.generalizedCostCalculator;
    }

    @Override
    public RaptorSlackProvider slackProvider() {
        return this.slackProvider;
    }

    @Override
    public RaptorPathConstrainedTransferSearch<TripSchedule> transferConstraintsSearch() {
        if (OTPFeature.TransferConstraints.isOff() || this.transferService == null) {
            return null;
        }
        return new RaptorPathConstrainedTransferSearch<TripSchedule>(){

            @Override
            @Nullable
            public RaptorConstrainedTransfer findConstrainedTransfer(TripSchedule fromTrip, int fromStopPosition, TripSchedule toTrip, int toStopPosition) {
                return RaptorRoutingRequestTransitData.this.transferService.findTransfer(fromTrip.getOriginalTripTimes().getTrip(), fromStopPosition, RaptorRoutingRequestTransitData.this.transitLayer.getStopByIndex(fromTrip.pattern().stopIndex(fromStopPosition)), toTrip.getOriginalTripTimes().getTrip(), toStopPosition, RaptorRoutingRequestTransitData.this.transitLayer.getStopByIndex(toTrip.pattern().stopIndex(toStopPosition)));
            }
        };
    }

    @Override
    @Nonnull
    public RaptorStopNameResolver stopNameResolver() {
        return stopIndex -> {
            StopLocation s = this.transitLayer.getStopByIndex(stopIndex);
            return s == null ? "null" : s.getName() + "(" + stopIndex + ")";
        };
    }

    @Override
    public int getValidTransitDataStartTime() {
        return this.validTransitDataStartTime;
    }

    @Override
    public int getValidTransitDataEndTime() {
        return this.validTransitDataEndTime;
    }

    @Override
    public RaptorConstrainedBoardingSearch<TripSchedule> transferConstraintsForwardSearch(int routeIndex) {
        TransferForPatternByStopPos fromStopTransfers = this.constrainedTransfers.fromStop(routeIndex);
        TransferForPatternByStopPos toStopTransfers = this.constrainedTransfers.toStop(routeIndex);
        if (fromStopTransfers == null && toStopTransfers == null) {
            return ConstrainedBoardingSearch.NOOP_SEARCH;
        }
        return new ConstrainedBoardingSearch(true, fromStopTransfers, toStopTransfers);
    }

    @Override
    public RaptorConstrainedBoardingSearch<TripSchedule> transferConstraintsReverseSearch(int routeIndex) {
        TransferForPatternByStopPos fromStopTransfers = this.constrainedTransfers.toStop(routeIndex);
        TransferForPatternByStopPos toStopTransfers = this.constrainedTransfers.fromStop(routeIndex);
        if (fromStopTransfers == null && toStopTransfers == null) {
            return ConstrainedBoardingSearch.NOOP_SEARCH;
        }
        return new ConstrainedBoardingSearch(false, toStopTransfers, fromStopTransfers);
    }
}

