/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.routing.algorithm.raptoradapter.transit.request;

import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.ExecutionException;
import javax.annotation.Nonnull;
import org.opentripplanner.framework.tostring.ToStringBuilder;
import org.opentripplanner.routing.algorithm.raptoradapter.transit.RaptorTransferIndex;
import org.opentripplanner.routing.algorithm.raptoradapter.transit.Transfer;
import org.opentripplanner.routing.api.request.RouteRequest;
import org.opentripplanner.routing.api.request.StreetMode;
import org.opentripplanner.routing.api.request.preference.BikePreferences;
import org.opentripplanner.routing.api.request.preference.RoutingPreferences;
import org.opentripplanner.routing.api.request.preference.StreetPreferences;
import org.opentripplanner.routing.api.request.preference.WalkPreferences;
import org.opentripplanner.routing.api.request.preference.WheelchairPreferences;
import org.opentripplanner.street.search.request.StreetSearchRequest;
import org.opentripplanner.street.search.request.StreetSearchRequestMapper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RaptorRequestTransferCache {
    private static final Logger LOG = LoggerFactory.getLogger(RaptorRequestTransferCache.class);
    private final LoadingCache<CacheKey, RaptorTransferIndex> transferCache;

    public RaptorRequestTransferCache(int maximumSize) {
        this.transferCache = CacheBuilder.newBuilder().maximumSize((long)maximumSize).build(this.cacheLoader());
    }

    public LoadingCache<CacheKey, RaptorTransferIndex> getTransferCache() {
        return this.transferCache;
    }

    public RaptorTransferIndex get(List<List<Transfer>> transfersByStopIndex, RouteRequest request) {
        try {
            return (RaptorTransferIndex)this.transferCache.get((Object)new CacheKey(transfersByStopIndex, StreetSearchRequestMapper.mapToTransferRequest(request).build()));
        }
        catch (ExecutionException e) {
            throw new RuntimeException("Failed to get item from transfer cache", e);
        }
    }

    private CacheLoader<CacheKey, RaptorTransferIndex> cacheLoader() {
        return new CacheLoader<CacheKey, RaptorTransferIndex>(){

            @Nonnull
            public RaptorTransferIndex load(@Nonnull CacheKey cacheKey) {
                LOG.info("Adding request to cache: {}", (Object)cacheKey.options);
                return RaptorTransferIndex.create(cacheKey.transfersByStopIndex, cacheKey.request);
            }
        };
    }

    private static class CacheKey {
        private final List<List<Transfer>> transfersByStopIndex;
        private final StreetSearchRequest request;
        private final StreetRelevantOptions options;

        private CacheKey(List<List<Transfer>> transfersByStopIndex, StreetSearchRequest request) {
            this.transfersByStopIndex = transfersByStopIndex;
            this.request = request;
            this.options = new StreetRelevantOptions(request);
        }

        public int hashCode() {
            return this.options.hashCode();
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            CacheKey cacheKey = (CacheKey)o;
            return this.transfersByStopIndex == cacheKey.transfersByStopIndex && this.options.equals(cacheKey.options);
        }
    }

    private static class StreetRelevantOptions {
        private final StreetMode transferMode;
        private final boolean wheelchair;
        private final WalkPreferences walk;
        private final BikePreferences bike;
        private final StreetPreferences street;
        private final WheelchairPreferences wheelchairPreferences;

        public StreetRelevantOptions(StreetSearchRequest request) {
            this.transferMode = request.mode();
            this.wheelchair = request.wheelchair();
            RoutingPreferences preferences = request.preferences();
            this.walk = preferences.walk();
            this.bike = this.transferMode.includesBiking() ? preferences.bike() : BikePreferences.DEFAULT;
            this.street = preferences.street();
            this.wheelchairPreferences = this.wheelchair ? preferences.wheelchair() : WheelchairPreferences.DEFAULT;
        }

        public String toString() {
            return ToStringBuilder.of(StreetRelevantOptions.class).addEnum("transferMode", this.transferMode).addBoolIfTrue("wheelchair", this.wheelchair).addObj("walk", this.walk, WalkPreferences.DEFAULT).addObj("bike", this.bike, BikePreferences.DEFAULT).addObj("street", this.street, StreetPreferences.DEFAULT).addObj("wheelchairPreferences", this.wheelchairPreferences, WheelchairPreferences.DEFAULT).toString();
        }

        public int hashCode() {
            return Objects.hash(new Object[]{this.transferMode, this.wheelchair, this.walk, this.bike, this.street, this.wheelchairPreferences});
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof StreetRelevantOptions)) {
                return false;
            }
            StreetRelevantOptions that = (StreetRelevantOptions)o;
            return this.transferMode == that.transferMode && this.wheelchair == that.wheelchair && Objects.equals(that.walk, this.walk) && Objects.equals(that.bike, this.bike) && Objects.equals(that.street, this.street) && Objects.equals(that.wheelchairPreferences, this.wheelchairPreferences);
        }
    }
}

