/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.routing.algorithm.raptoradapter.transit.cost;

import javax.annotation.Nonnull;
import org.opentripplanner.raptor.api.model.RaptorAccessEgress;
import org.opentripplanner.raptor.api.model.RaptorTransferConstraint;
import org.opentripplanner.raptor.spi.RaptorCostCalculator;
import org.opentripplanner.routing.algorithm.raptoradapter.transit.cost.DefaultTripSchedule;
import org.opentripplanner.routing.algorithm.raptoradapter.transit.cost.RaptorCostConverter;
import org.opentripplanner.routing.api.request.preference.AccessibilityPreferences;
import org.opentripplanner.transit.model.basic.Accessibility;

public class WheelchairCostCalculator<T extends DefaultTripSchedule>
implements RaptorCostCalculator<T> {
    private final RaptorCostCalculator<T> delegate;
    private final int[] wheelchairBoardingCost;

    public WheelchairCostCalculator(@Nonnull RaptorCostCalculator<T> delegate, @Nonnull AccessibilityPreferences wheelchairAccessibility) {
        this.delegate = delegate;
        this.wheelchairBoardingCost = WheelchairCostCalculator.createWheelchairCost(wheelchairAccessibility);
    }

    @Override
    public int boardingCost(boolean firstBoarding, int prevArrivalTime, int boardStop, int boardTime, T trip, RaptorTransferConstraint transferConstraints) {
        int defaultCost = this.delegate.boardingCost(firstBoarding, prevArrivalTime, boardStop, boardTime, trip, transferConstraints);
        int index = trip.wheelchairBoarding().ordinal();
        int wheelchairCost = this.wheelchairBoardingCost[index];
        return defaultCost + wheelchairCost;
    }

    @Override
    public int onTripRelativeRidingCost(int boardTime, T tripScheduledBoarded) {
        return this.delegate.onTripRelativeRidingCost(boardTime, tripScheduledBoarded);
    }

    @Override
    public int transitArrivalCost(int boardCost, int alightSlack, int transitTime, T trip, int toStop) {
        return this.delegate.transitArrivalCost(boardCost, alightSlack, transitTime, trip, toStop);
    }

    @Override
    public int waitCost(int waitTimeInSeconds) {
        return this.delegate.waitCost(waitTimeInSeconds);
    }

    @Override
    public int calculateMinCost(int minTravelTime, int minNumTransfers) {
        return this.delegate.calculateMinCost(minTravelTime, minNumTransfers);
    }

    @Override
    public int costEgress(RaptorAccessEgress egress) {
        return this.delegate.costEgress(egress);
    }

    private static int[] createWheelchairCost(AccessibilityPreferences requirements) {
        int[] costIndex = new int[Accessibility.values().length];
        for (Accessibility it : Accessibility.values()) {
            int n = it.ordinal();
            costIndex[n] = switch (it) {
                default -> throw new IncompatibleClassChangeError();
                case Accessibility.POSSIBLE -> 0;
                case Accessibility.NO_INFORMATION -> RaptorCostConverter.toRaptorCost(requirements.unknownCost());
                case Accessibility.NOT_POSSIBLE -> RaptorCostConverter.toRaptorCost(requirements.inaccessibleCost());
            };
        }
        return costIndex;
    }
}

