/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.routing.algorithm.raptoradapter.transit.cost;

import javax.annotation.Nullable;
import org.opentripplanner.model.transfer.TransferConstraint;
import org.opentripplanner.raptor.api.model.RaptorAccessEgress;
import org.opentripplanner.raptor.api.model.RaptorTransferConstraint;
import org.opentripplanner.raptor.spi.RaptorCostCalculator;
import org.opentripplanner.routing.algorithm.raptoradapter.transit.cost.DefaultTripSchedule;
import org.opentripplanner.routing.algorithm.raptoradapter.transit.cost.FactorStrategy;
import org.opentripplanner.routing.algorithm.raptoradapter.transit.cost.GeneralizedCostParameters;
import org.opentripplanner.routing.algorithm.raptoradapter.transit.cost.IndexBasedFactorStrategy;
import org.opentripplanner.routing.algorithm.raptoradapter.transit.cost.RaptorCostConverter;
import org.opentripplanner.routing.algorithm.raptoradapter.transit.cost.SingleValueFactorStrategy;

public final class DefaultCostCalculator<T extends DefaultTripSchedule>
implements RaptorCostCalculator<T> {
    private final int boardCostOnly;
    private final int transferCostOnly;
    private final int boardAndTransferCost;
    private final int waitFactor;
    private final FactorStrategy transitFactors;
    private final int[] stopTransferCost;

    public DefaultCostCalculator(int boardCost, int transferCost, double waitReluctanceFactor, @Nullable double[] transitReluctanceFactors, @Nullable int[] stopTransferCost) {
        this.boardCostOnly = RaptorCostConverter.toRaptorCost(boardCost);
        this.transferCostOnly = RaptorCostConverter.toRaptorCost(transferCost);
        this.boardAndTransferCost = this.transferCostOnly + this.boardCostOnly;
        this.waitFactor = RaptorCostConverter.toRaptorCost(waitReluctanceFactor);
        this.transitFactors = transitReluctanceFactors == null ? new SingleValueFactorStrategy(1.0) : new IndexBasedFactorStrategy(transitReluctanceFactors);
        this.stopTransferCost = stopTransferCost;
    }

    public DefaultCostCalculator(GeneralizedCostParameters params, int[] stopTransferCost) {
        this(params.boardCost(), params.transferCost(), params.waitReluctanceFactor(), params.transitReluctanceFactors(), stopTransferCost);
    }

    @Override
    public int boardingCost(boolean firstBoarding, int prevArrivalTime, int boardStop, int boardTime, T trip, RaptorTransferConstraint transferConstraints) {
        if (transferConstraints.isRegularTransfer()) {
            return this.boardingCostRegularTransfer(firstBoarding, prevArrivalTime, boardStop, boardTime);
        }
        return this.boardingCostConstrainedTransfer(prevArrivalTime, boardStop, boardTime, trip.transitReluctanceFactorIndex(), firstBoarding, transferConstraints);
    }

    @Override
    public int onTripRelativeRidingCost(int boardTime, DefaultTripSchedule tripScheduledBoarded) {
        return -boardTime * this.transitFactors.factor(tripScheduledBoarded.transitReluctanceFactorIndex());
    }

    @Override
    public int transitArrivalCost(int boardCost, int alightSlack, int transitTime, T trip, int toStop) {
        int cost = boardCost + this.transitFactors.factor(trip.transitReluctanceFactorIndex()) * transitTime + this.waitFactor * alightSlack;
        if (this.stopTransferCost != null) {
            cost += this.stopTransferCost[toStop];
        }
        return cost;
    }

    @Override
    public int waitCost(int waitTimeInSeconds) {
        return this.waitFactor * waitTimeInSeconds;
    }

    @Override
    public int calculateMinCost(int minTravelTime, int minNumTransfers) {
        return this.boardCostOnly + this.boardAndTransferCost * minNumTransfers + this.transitFactors.minFactor() * minTravelTime;
    }

    @Override
    public int costEgress(RaptorAccessEgress egress) {
        if (egress.hasRides()) {
            return egress.generalizedCost() + this.transferCostOnly;
        }
        if (this.stopTransferCost != null) {
            return egress.generalizedCost() - this.stopTransferCost[egress.stop()];
        }
        return egress.generalizedCost();
    }

    public int boardingCostRegularTransfer(boolean firstBoarding, int prevArrivalTime, int boardStop, int boardTime) {
        int boardWaitTime = boardTime - prevArrivalTime;
        int cost = this.waitFactor * boardWaitTime;
        cost += firstBoarding ? this.boardCostOnly : this.boardAndTransferCost;
        if (this.stopTransferCost != null && !firstBoarding) {
            cost += this.stopTransferCost[boardStop];
        }
        return cost;
    }

    private int boardingCostConstrainedTransfer(int prevArrivalTime, int boardStop, int boardTime, int transitReluctanceIndex, boolean firstBoarding, RaptorTransferConstraint txConstraints) {
        TransferConstraint tx = (TransferConstraint)txConstraints;
        if (tx.isStaySeated()) {
            int boardWaitTime = boardTime - prevArrivalTime;
            int transitReluctance = this.transitFactors.factor(transitReluctanceIndex);
            return transitReluctance * boardWaitTime;
        }
        if (tx.isGuaranteed()) {
            int boardWaitTime = boardTime - prevArrivalTime;
            return this.waitFactor * boardWaitTime;
        }
        return this.boardingCostRegularTransfer(firstBoarding, prevArrivalTime, boardStop, boardTime);
    }
}

