/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.routing.algorithm.raptoradapter.transit;

import javax.annotation.Nullable;
import org.opentripplanner.raptor.api.model.RaptorAccessEgress;
import org.opentripplanner.routing.algorithm.raptoradapter.transit.cost.RaptorCostConverter;
import org.opentripplanner.street.search.state.State;

public class DefaultAccessEgress
implements RaptorAccessEgress {
    private final int stop;
    private final int durationInSeconds;
    private final int generalizedCost;
    private final State lastState;

    public DefaultAccessEgress(int stop, State lastState) {
        this.stop = stop;
        this.durationInSeconds = (int)lastState.getElapsedTimeSeconds();
        this.generalizedCost = RaptorCostConverter.toRaptorCost(lastState.getWeight());
        this.lastState = lastState;
    }

    @Override
    public boolean hasOpeningHours() {
        return false;
    }

    @Override
    public int durationInSeconds() {
        return this.durationInSeconds;
    }

    @Override
    public int stop() {
        return this.stop;
    }

    @Override
    public int generalizedCost() {
        return this.generalizedCost;
    }

    @Override
    @Nullable
    public String openingHoursToString() {
        return null;
    }

    public State getLastState() {
        return this.lastState;
    }

    public String toString() {
        return this.asString(true) + (String)(this.lastState != null ? " (" + this.lastState + ")" : "");
    }
}

