/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.routing.algorithm.raptoradapter.router.street;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.opentripplanner.ext.flex.FlexRouter;
import org.opentripplanner.model.plan.Itinerary;
import org.opentripplanner.routing.algorithm.raptoradapter.router.AdditionalSearchDays;
import org.opentripplanner.routing.algorithm.raptoradapter.router.street.AccessEgressRouter;
import org.opentripplanner.routing.api.request.RouteRequest;
import org.opentripplanner.routing.api.request.StreetMode;
import org.opentripplanner.routing.graphfinder.NearbyStop;
import org.opentripplanner.standalone.api.OtpServerRequestContext;
import org.opentripplanner.street.search.TemporaryVerticesContainer;

public class DirectFlexRouter {
    public static List<Itinerary> route(OtpServerRequestContext serverContext, RouteRequest request, AdditionalSearchDays additionalSearchDays) {
        if (!StreetMode.FLEXIBLE.equals((Object)request.journey().direct().mode())) {
            return Collections.emptyList();
        }
        try (TemporaryVerticesContainer temporaryVertices = new TemporaryVerticesContainer(serverContext.graph(), request, request.journey().direct().mode(), request.journey().direct().mode());){
            Collection<NearbyStop> accessStops = AccessEgressRouter.streetSearch(request, temporaryVertices, serverContext.transitService(), request.journey().direct(), serverContext.dataOverlayContext(request), false, serverContext.flexConfig().maxAccessWalkDuration());
            Collection<NearbyStop> egressStops = AccessEgressRouter.streetSearch(request, temporaryVertices, serverContext.transitService(), request.journey().direct(), serverContext.dataOverlayContext(request), true, serverContext.flexConfig().maxEgressWalkDuration());
            FlexRouter flexRouter = new FlexRouter(serverContext.graph(), serverContext.transitService(), serverContext.flexConfig(), request.dateTime(), request.arriveBy(), additionalSearchDays.additionalSearchDaysInPast(), additionalSearchDays.additionalSearchDaysInFuture(), accessStops, egressStops);
            ArrayList<Itinerary> arrayList = new ArrayList<Itinerary>(flexRouter.createFlexOnlyItineraries());
            return arrayList;
        }
    }
}

