/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.routing.algorithm.raptoradapter.router.street;

import java.time.Duration;
import java.util.Collection;
import java.util.List;
import org.opentripplanner.ext.dataoverlay.routing.DataOverlayContext;
import org.opentripplanner.graph_builder.module.NearbyStopFinder;
import org.opentripplanner.routing.api.request.RouteRequest;
import org.opentripplanner.routing.api.request.request.StreetRequest;
import org.opentripplanner.routing.graphfinder.NearbyStop;
import org.opentripplanner.street.search.TemporaryVerticesContainer;
import org.opentripplanner.transit.service.TransitService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AccessEgressRouter {
    private static final Logger LOG = LoggerFactory.getLogger(AccessEgressRouter.class);

    private AccessEgressRouter() {
    }

    public static Collection<NearbyStop> streetSearch(RouteRequest request, TemporaryVerticesContainer verticesContainer, TransitService transitService, StreetRequest streetRequest, DataOverlayContext dataOverlayContext, boolean fromTarget, Duration durationLimit) {
        NearbyStopFinder nearbyStopFinder = new NearbyStopFinder(transitService, durationLimit, dataOverlayContext, true);
        List<NearbyStop> nearbyStopList = nearbyStopFinder.findNearbyStopsViaStreets(fromTarget ? verticesContainer.getToVertices() : verticesContainer.getFromVertices(), fromTarget, request, streetRequest);
        LOG.debug("Found {} {} stops", (Object)nearbyStopList.size(), (Object)(fromTarget ? "egress" : "access"));
        return nearbyStopList;
    }
}

