/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.routing.algorithm.raptoradapter.router;

import java.time.ZonedDateTime;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import org.opentripplanner.ext.flex.FlexAccessEgress;
import org.opentripplanner.framework.application.OTPFeature;
import org.opentripplanner.model.plan.Itinerary;
import org.opentripplanner.raptor.RaptorService;
import org.opentripplanner.raptor.api.path.RaptorPath;
import org.opentripplanner.raptor.api.request.RaptorRequest;
import org.opentripplanner.raptor.api.response.RaptorResponse;
import org.opentripplanner.routing.algorithm.mapping.RaptorPathToItineraryMapper;
import org.opentripplanner.routing.algorithm.raptoradapter.router.AccessEgresses;
import org.opentripplanner.routing.algorithm.raptoradapter.router.AdditionalSearchDays;
import org.opentripplanner.routing.algorithm.raptoradapter.router.TransitRouterResult;
import org.opentripplanner.routing.algorithm.raptoradapter.router.street.AccessEgressRouter;
import org.opentripplanner.routing.algorithm.raptoradapter.router.street.FlexAccessEgressRouter;
import org.opentripplanner.routing.algorithm.raptoradapter.transit.DefaultAccessEgress;
import org.opentripplanner.routing.algorithm.raptoradapter.transit.TransitLayer;
import org.opentripplanner.routing.algorithm.raptoradapter.transit.TripSchedule;
import org.opentripplanner.routing.algorithm.raptoradapter.transit.mappers.AccessEgressMapper;
import org.opentripplanner.routing.algorithm.raptoradapter.transit.mappers.RaptorRequestMapper;
import org.opentripplanner.routing.algorithm.raptoradapter.transit.request.RaptorRoutingRequestTransitData;
import org.opentripplanner.routing.algorithm.raptoradapter.transit.request.RouteRequestTransitDataProviderFilter;
import org.opentripplanner.routing.algorithm.transferoptimization.configure.TransferOptimizationServiceConfigurator;
import org.opentripplanner.routing.api.request.RouteRequest;
import org.opentripplanner.routing.api.request.StreetMode;
import org.opentripplanner.routing.api.request.request.StreetRequest;
import org.opentripplanner.routing.api.response.InputField;
import org.opentripplanner.routing.api.response.RoutingError;
import org.opentripplanner.routing.api.response.RoutingErrorCode;
import org.opentripplanner.routing.error.RoutingValidationException;
import org.opentripplanner.routing.framework.DebugTimingAggregator;
import org.opentripplanner.routing.graphfinder.NearbyStop;
import org.opentripplanner.standalone.api.OtpServerRequestContext;
import org.opentripplanner.street.search.TemporaryVerticesContainer;

public class TransitRouter {
    public static final int NOT_SET = -1;
    private final RouteRequest request;
    private final OtpServerRequestContext serverContext;
    private final DebugTimingAggregator debugTimingAggregator;
    private final ZonedDateTime transitSearchTimeZero;
    private final AdditionalSearchDays additionalSearchDays;

    private TransitRouter(RouteRequest request, OtpServerRequestContext serverContext, ZonedDateTime transitSearchTimeZero, AdditionalSearchDays additionalSearchDays, DebugTimingAggregator debugTimingAggregator) {
        this.request = request;
        this.serverContext = serverContext;
        this.transitSearchTimeZero = transitSearchTimeZero;
        this.additionalSearchDays = additionalSearchDays;
        this.debugTimingAggregator = debugTimingAggregator;
    }

    public static TransitRouterResult route(RouteRequest request, OtpServerRequestContext serverContext, ZonedDateTime transitSearchTimeZero, AdditionalSearchDays additionalSearchDays, DebugTimingAggregator debugTimingAggregator) {
        TransitRouter transitRouter = new TransitRouter(request, serverContext, transitSearchTimeZero, additionalSearchDays, debugTimingAggregator);
        try (TemporaryVerticesContainer temporaryVertices = new TemporaryVerticesContainer(serverContext.graph(), request, request.journey().access().mode(), request.journey().egress().mode());){
            TransitRouterResult transitRouterResult = transitRouter.route(temporaryVertices);
            return transitRouterResult;
        }
    }

    private TransitRouterResult route(TemporaryVerticesContainer temporaryVertices) {
        if (!this.request.journey().transit().enabled()) {
            return new TransitRouterResult(List.of(), null);
        }
        if (!this.serverContext.transitService().transitFeedCovers(this.request.dateTime())) {
            throw new RoutingValidationException(List.of(new RoutingError(RoutingErrorCode.OUTSIDE_SERVICE_PERIOD, InputField.DATE_TIME)));
        }
        TransitLayer transitLayer = this.request.preferences().transit().ignoreRealtimeUpdates() ? this.serverContext.transitService().getTransitLayer() : this.serverContext.transitService().getRealtimeTransitLayer();
        RaptorRoutingRequestTransitData requestTransitDataProvider = this.createRequestTransitDataProvider(transitLayer);
        this.debugTimingAggregator.finishedPatternFiltering();
        AccessEgresses accessEgresses = this.getAccessEgresses(temporaryVertices);
        this.debugTimingAggregator.finishedAccessEgress(accessEgresses.getAccesses().size(), accessEgresses.getEgresses().size());
        RaptorRequest<TripSchedule> raptorRequest = RaptorRequestMapper.mapRequest(this.request, this.transitSearchTimeZero, this.serverContext.raptorConfig().isMultiThreaded(), accessEgresses.getAccesses(), accessEgresses.getEgresses(), this.serverContext.meterRegistry());
        RaptorService<TripSchedule> raptorService = new RaptorService<TripSchedule>(this.serverContext.raptorConfig());
        RaptorResponse<TripSchedule> transitResponse = raptorService.route(raptorRequest, requestTransitDataProvider);
        this.checkIfTransitConnectionExists(transitResponse);
        this.debugTimingAggregator.finishedRaptorSearch();
        Collection<RaptorPath<TripSchedule>> paths = transitResponse.paths();
        if (OTPFeature.OptimizeTransfers.isOn() && !transitResponse.containsUnknownPaths()) {
            paths = TransferOptimizationServiceConfigurator.createOptimizeTransferService(transitLayer::getStopByIndex, requestTransitDataProvider.stopNameResolver(), this.serverContext.transitService().getTransferService(), requestTransitDataProvider, transitLayer.getStopBoardAlightCosts(), this.request.preferences().transfer().optimization()).optimize(transitResponse.paths());
        }
        RaptorPathToItineraryMapper itineraryMapper = new RaptorPathToItineraryMapper(this.serverContext.graph(), this.serverContext.transitService(), transitLayer, this.transitSearchTimeZero, this.request);
        List<Itinerary> itineraries = paths.stream().map(itineraryMapper::createItinerary).toList();
        this.debugTimingAggregator.finishedItineraryCreation();
        return new TransitRouterResult(itineraries, transitResponse.requestUsed().searchParams());
    }

    private AccessEgresses getAccessEgresses(TemporaryVerticesContainer temporaryVertices) {
        AccessEgressMapper accessEgressMapper = new AccessEgressMapper();
        ArrayList<DefaultAccessEgress> accessList = new ArrayList<DefaultAccessEgress>();
        ArrayList<DefaultAccessEgress> egressList = new ArrayList<DefaultAccessEgress>();
        Runnable accessCalculator = () -> {
            this.debugTimingAggregator.startedAccessCalculating();
            accessList.addAll(this.getAccessEgresses(accessEgressMapper, temporaryVertices, false));
            this.debugTimingAggregator.finishedAccessCalculating();
        };
        Runnable egressCalculator = () -> {
            this.debugTimingAggregator.startedEgressCalculating();
            egressList.addAll(this.getAccessEgresses(accessEgressMapper, temporaryVertices, true));
            this.debugTimingAggregator.finishedEgressCalculating();
        };
        if (OTPFeature.ParallelRouting.isOn()) {
            try {
                CompletableFuture.allOf(CompletableFuture.runAsync(accessCalculator), CompletableFuture.runAsync(egressCalculator)).join();
            }
            catch (CompletionException e) {
                RoutingValidationException.unwrapAndRethrowCompletionException(e);
            }
        } else {
            accessCalculator.run();
            egressCalculator.run();
        }
        this.verifyAccessEgress(accessList, egressList);
        return new AccessEgresses(accessList, egressList);
    }

    private Collection<DefaultAccessEgress> getAccessEgresses(AccessEgressMapper accessEgressMapper, TemporaryVerticesContainer temporaryVertices, boolean isEgress) {
        StreetRequest streetRequest = isEgress ? this.request.journey().egress() : this.request.journey().access();
        RouteRequest accessRequest = this.request.clone();
        if (!isEgress) {
            accessRequest.journey().rental().setAllowArrivingInRentedVehicleAtDestination(false);
        }
        Collection<NearbyStop> nearbyStops = AccessEgressRouter.streetSearch(accessRequest, temporaryVertices, this.serverContext.transitService(), streetRequest, this.serverContext.dataOverlayContext(accessRequest), isEgress, accessRequest.preferences().street().maxAccessEgressDuration().valueOf(streetRequest.mode()));
        ArrayList<DefaultAccessEgress> results = new ArrayList<DefaultAccessEgress>(accessEgressMapper.mapNearbyStops(nearbyStops, isEgress));
        if (OTPFeature.FlexRouting.isOn() && streetRequest.mode() == StreetMode.FLEXIBLE) {
            Collection<FlexAccessEgress> flexAccessList = FlexAccessEgressRouter.routeAccessEgress(accessRequest, temporaryVertices, this.serverContext, this.additionalSearchDays, this.serverContext.flexConfig(), this.serverContext.dataOverlayContext(accessRequest), isEgress);
            results.addAll(accessEgressMapper.mapFlexAccessEgresses(flexAccessList, isEgress));
        }
        return results;
    }

    private RaptorRoutingRequestTransitData createRequestTransitDataProvider(TransitLayer transitLayer) {
        return new RaptorRoutingRequestTransitData(transitLayer, this.transitSearchTimeZero, this.additionalSearchDays.additionalSearchDaysInPast(), this.additionalSearchDays.additionalSearchDaysInFuture(), new RouteRequestTransitDataProviderFilter(this.request), this.request);
    }

    private void verifyAccessEgress(Collection<?> access, Collection<?> egress) {
        boolean egressExist;
        boolean accessExist = !access.isEmpty();
        boolean bl = egressExist = !egress.isEmpty();
        if (accessExist && egressExist) {
            return;
        }
        ArrayList<RoutingError> routingErrors = new ArrayList<RoutingError>();
        if (!accessExist) {
            routingErrors.add(new RoutingError(RoutingErrorCode.NO_STOPS_IN_RANGE, InputField.FROM_PLACE));
        }
        if (!egressExist) {
            routingErrors.add(new RoutingError(RoutingErrorCode.NO_STOPS_IN_RANGE, InputField.TO_PLACE));
        }
        throw new RoutingValidationException(routingErrors);
    }

    private void checkIfTransitConnectionExists(RaptorResponse<TripSchedule> response) {
        int searchWindowUsed = response.requestUsed().searchParams().searchWindowInSeconds();
        if (searchWindowUsed <= 0 && response.paths().isEmpty()) {
            throw new RoutingValidationException(List.of(new RoutingError(RoutingErrorCode.NO_TRANSIT_CONNECTION, null)));
        }
    }
}

