/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.routing.algorithm.raptoradapter.router;

import java.time.Duration;
import java.time.Period;
import java.time.ZonedDateTime;
import java.util.Objects;
import javax.annotation.Nullable;

public class AdditionalSearchDays {
    private final boolean arriveBy;
    private final ZonedDateTime searchDateTime;
    @Nullable
    private final Duration searchWindow;
    private final Duration maxSearchWindow;
    private final Duration maxJourneyDuration;

    public AdditionalSearchDays(boolean arriveBy, ZonedDateTime searchDateTime, @Nullable Duration searchWindow, Duration maxSearchWindow, Duration maxJourneyDuration) {
        this.arriveBy = arriveBy;
        this.searchDateTime = searchDateTime;
        this.searchWindow = searchWindow;
        this.maxSearchWindow = maxSearchWindow;
        this.maxJourneyDuration = maxJourneyDuration;
    }

    public static AdditionalSearchDays defaults(ZonedDateTime time) {
        return new AdditionalSearchDays(false, time, Duration.ofHours(6L), Duration.ofDays(1L), Duration.ofDays(1L));
    }

    public int additionalSearchDaysInPast() {
        if (this.arriveBy) {
            Duration sw = this.getSearchWindowOrElseMax();
            ZonedDateTime earliestStart = this.searchDateTime.minus(this.maxJourneyDuration.plus(sw));
            return this.daysInBetween(this.searchDateTime, earliestStart);
        }
        return 0;
    }

    public int additionalSearchDaysInFuture() {
        if (this.arriveBy) {
            return 0;
        }
        Duration sw = this.getSearchWindowOrElseMax();
        ZonedDateTime requestTime = this.searchDateTime;
        ZonedDateTime lastArrival = requestTime.plus(this.maxJourneyDuration.plus(sw));
        return this.daysInBetween(requestTime, lastArrival);
    }

    private Duration getSearchWindowOrElseMax() {
        return Objects.requireNonNullElse(this.searchWindow, this.maxSearchWindow);
    }

    private int daysInBetween(ZonedDateTime requestTime, ZonedDateTime earliestStart) {
        return Math.abs(Period.between(requestTime.toLocalDate(), earliestStart.toLocalDate()).getDays());
    }
}

